package io.github.vigoo.zioaws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait DataSourceType {
  def unwrap: software.amazon.awssdk.services.grafana.model.DataSourceType
}
object DataSourceType {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.DataSourceType
  ): io.github.vigoo.zioaws.grafana.model.DataSourceType = value match {
    case software.amazon.awssdk.services.grafana.model.DataSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.AMAZON_OPENSEARCH_SERVICE =>
      val r = AMAZON_OPENSEARCH_SERVICE
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.CLOUDWATCH =>
      val r = CLOUDWATCH
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.PROMETHEUS =>
      val r = PROMETHEUS
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.XRAY =>
      val r = XRAY
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.TIMESTREAM =>
      val r = TIMESTREAM
      r
    case software.amazon.awssdk.services.grafana.model.DataSourceType.SITEWISE =>
      val r = SITEWISE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object AMAZON_OPENSEARCH_SERVICE
      extends io.github.vigoo.zioaws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.AMAZON_OPENSEARCH_SERVICE
  }
  case object CLOUDWATCH
      extends io.github.vigoo.zioaws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.CLOUDWATCH
  }
  case object PROMETHEUS
      extends io.github.vigoo.zioaws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.PROMETHEUS
  }
  case object XRAY extends io.github.vigoo.zioaws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.XRAY
  }
  case object TIMESTREAM
      extends io.github.vigoo.zioaws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.TIMESTREAM
  }
  case object SITEWISE
      extends io.github.vigoo.zioaws.grafana.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.DataSourceType =
      software.amazon.awssdk.services.grafana.model.DataSourceType.SITEWISE
  }
}
