package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.SSOClientId
import scala.jdk.CollectionConverters.*
final case class AwsSsoAuthentication(ssoClientId: Option[SSOClientId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication = {
    import AwsSsoAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication
      .builder()
      .optionallyWith(ssoClientId.map(value => value: java.lang.String))(
        _.ssoClientId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication
      .wrap(buildAwsValue())
}
object AwsSsoAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication =
      io.github.vigoo.zioaws.grafana.model
        .AwsSsoAuthentication(ssoClientIdValue.map(value => value))
    def ssoClientIdValue: Option[SSOClientId]
    def ssoClientId: ZIO[Any, AwsError, SSOClientId] =
      AwsError.unwrapOptionField("ssoClientId", ssoClientIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication
  ) extends io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication.ReadOnly {
    override def ssoClientIdValue: Option[SSOClientId] =
      scala.Option(impl.ssoClientId()).map(value => value: SSOClientId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication
  ): io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication.ReadOnly =
    new Wrapper(impl)
}
