package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuthenticationSummary(
    providers: Iterable[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ],
    samlConfigurationStatus: Option[
      io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AuthenticationSummary = {
    import AuthenticationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AuthenticationSummary
      .builder()
      .providersWithStrings(providers.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(samlConfigurationStatus.map(value => value.unwrap))(
        _.samlConfigurationStatus
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.AuthenticationSummary
      .wrap(buildAwsValue())
}
object AuthenticationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AuthenticationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.AuthenticationSummary =
      io.github.vigoo.zioaws.grafana.model.AuthenticationSummary(
        providersValue,
        samlConfigurationStatusValue.map(value => value)
      )
    def providersValue
        : List[io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes]
    def samlConfigurationStatusValue
        : Option[io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus]
    def providers: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(providersValue)
    def samlConfigurationStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus
    ] = AwsError.unwrapOptionField(
      "samlConfigurationStatus",
      samlConfigurationStatusValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AuthenticationSummary
  ) extends io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly {
    override def providersValue: List[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ] = impl
      .providers()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
          .wrap(item)
      }
      .toList
    override def samlConfigurationStatusValue
        : Option[io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus] =
      scala
        .Option(impl.samlConfigurationStatus())
        .map(value =>
          io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AuthenticationSummary
  ): io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly =
    new Wrapper(impl)
}
