package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AuthenticationDescription(
    awsSso: Option[io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication] =
      None,
    providers: Iterable[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ],
    saml: Option[io.github.vigoo.zioaws.grafana.model.SamlAuthentication] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AuthenticationDescription = {
    import AuthenticationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AuthenticationDescription
      .builder()
      .optionallyWith(awsSso.map(value => value.buildAwsValue()))(_.awsSso)
      .providersWithStrings(providers.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(saml.map(value => value.buildAwsValue()))(_.saml)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.AuthenticationDescription
      .wrap(buildAwsValue())
}
object AuthenticationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AuthenticationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.AuthenticationDescription =
      io.github.vigoo.zioaws.grafana.model.AuthenticationDescription(
        awsSsoValue.map(value => value.editable),
        providersValue,
        samlValue.map(value => value.editable)
      )
    def awsSsoValue: Option[
      io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication.ReadOnly
    ]
    def providersValue
        : List[io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes]
    def samlValue: Option[
      io.github.vigoo.zioaws.grafana.model.SamlAuthentication.ReadOnly
    ]
    def awsSso: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("awsSso", awsSsoValue)
    def providers: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(providersValue)
    def saml: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.SamlAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("saml", samlValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AuthenticationDescription
  ) extends io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly {
    override def awsSsoValue: Option[
      io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication.ReadOnly
    ] = scala
      .Option(impl.awsSso())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.AwsSsoAuthentication.wrap(value)
      )
    override def providersValue: List[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ] = impl
      .providers()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
          .wrap(item)
      }
      .toList
    override def samlValue: Option[
      io.github.vigoo.zioaws.grafana.model.SamlAuthentication.ReadOnly
    ] = scala
      .Option(impl.saml())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.SamlAuthentication.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AuthenticationDescription
  ): io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly =
    new Wrapper(impl)
}
