package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class AssociateLicenseRequest(
    licenseType: io.github.vigoo.zioaws.grafana.model.LicenseType,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest = {
    import AssociateLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest
      .builder()
      .licenseType(licenseType.unwrap)
      .workspaceId(workspaceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.AssociateLicenseRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.AssociateLicenseRequest
      .wrap(buildAwsValue())
}
object AssociateLicenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.AssociateLicenseRequest =
      io.github.vigoo.zioaws.grafana.model
        .AssociateLicenseRequest(licenseTypeValue, workspaceIdValue)
    def licenseTypeValue: io.github.vigoo.zioaws.grafana.model.LicenseType
    def workspaceIdValue: WorkspaceId
    def licenseType
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.grafana.model.LicenseType] =
      ZIO.succeed(licenseTypeValue)
    def workspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest
  ) extends io.github.vigoo.zioaws.grafana.model.AssociateLicenseRequest.ReadOnly {
    override def licenseTypeValue
        : io.github.vigoo.zioaws.grafana.model.LicenseType =
      io.github.vigoo.zioaws.grafana.model.LicenseType.wrap(impl.licenseType())
    override def workspaceIdValue: WorkspaceId = impl.workspaceId(): WorkspaceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest
  ): io.github.vigoo.zioaws.grafana.model.AssociateLicenseRequest.ReadOnly =
    new Wrapper(impl)
}
