package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.AssertionAttribute
import scala.jdk.CollectionConverters.*
final case class AssertionAttributes(
    email: Option[AssertionAttribute] = None,
    groups: Option[AssertionAttribute] = None,
    login: Option[AssertionAttribute] = None,
    name: Option[AssertionAttribute] = None,
    org: Option[AssertionAttribute] = None,
    role: Option[AssertionAttribute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AssertionAttributes = {
    import AssertionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AssertionAttributes
      .builder()
      .optionallyWith(email.map(value => value: java.lang.String))(_.email)
      .optionallyWith(groups.map(value => value: java.lang.String))(_.groups)
      .optionallyWith(login.map(value => value: java.lang.String))(_.login)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(org.map(value => value: java.lang.String))(_.org)
      .optionallyWith(role.map(value => value: java.lang.String))(_.role)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.AssertionAttributes.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.AssertionAttributes
      .wrap(buildAwsValue())
}
object AssertionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AssertionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.AssertionAttributes =
      io.github.vigoo.zioaws.grafana.model.AssertionAttributes(
        emailValue.map(value => value),
        groupsValue.map(value => value),
        loginValue.map(value => value),
        nameValue.map(value => value),
        orgValue.map(value => value),
        roleValue.map(value => value)
      )
    def emailValue: Option[AssertionAttribute]
    def groupsValue: Option[AssertionAttribute]
    def loginValue: Option[AssertionAttribute]
    def nameValue: Option[AssertionAttribute]
    def orgValue: Option[AssertionAttribute]
    def roleValue: Option[AssertionAttribute]
    def email: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("email", emailValue)
    def groups: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("groups", groupsValue)
    def login: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("login", loginValue)
    def name: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("name", nameValue)
    def org: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("org", orgValue)
    def role: ZIO[Any, AwsError, AssertionAttribute] =
      AwsError.unwrapOptionField("role", roleValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AssertionAttributes
  ) extends io.github.vigoo.zioaws.grafana.model.AssertionAttributes.ReadOnly {
    override def emailValue: Option[AssertionAttribute] =
      scala.Option(impl.email()).map(value => value: AssertionAttribute)
    override def groupsValue: Option[AssertionAttribute] =
      scala.Option(impl.groups()).map(value => value: AssertionAttribute)
    override def loginValue: Option[AssertionAttribute] =
      scala.Option(impl.login()).map(value => value: AssertionAttribute)
    override def nameValue: Option[AssertionAttribute] =
      scala.Option(impl.name()).map(value => value: AssertionAttribute)
    override def orgValue: Option[AssertionAttribute] =
      scala.Option(impl.org()).map(value => value: AssertionAttribute)
    override def roleValue: Option[AssertionAttribute] =
      scala.Option(impl.role()).map(value => value: AssertionAttribute)
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AssertionAttributes
  ): io.github.vigoo.zioaws.grafana.model.AssertionAttributes.ReadOnly =
    new Wrapper(impl)
}
