package io.github.vigoo.zioaws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait AccountAccessType {
  def unwrap: software.amazon.awssdk.services.grafana.model.AccountAccessType
}
object AccountAccessType {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.AccountAccessType
  ): io.github.vigoo.zioaws.grafana.model.AccountAccessType = value match {
    case software.amazon.awssdk.services.grafana.model.AccountAccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.AccountAccessType.CURRENT_ACCOUNT =>
      val r = CURRENT_ACCOUNT
      r
    case software.amazon.awssdk.services.grafana.model.AccountAccessType.ORGANIZATION =>
      val r = ORGANIZATION
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.grafana.model.AccountAccessType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AccountAccessType =
      software.amazon.awssdk.services.grafana.model.AccountAccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object CURRENT_ACCOUNT
      extends io.github.vigoo.zioaws.grafana.model.AccountAccessType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AccountAccessType =
      software.amazon.awssdk.services.grafana.model.AccountAccessType.CURRENT_ACCOUNT
  }
  case object ORGANIZATION
      extends io.github.vigoo.zioaws.grafana.model.AccountAccessType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AccountAccessType =
      software.amazon.awssdk.services.grafana.model.AccountAccessType.ORGANIZATION
  }
}
