package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NextPageToken,
  MetricName
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCostAndUsageRequest(
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    granularity: io.github.vigoo.zioaws.costexplorer.model.Granularity,
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    metrics: Iterable[MetricName],
    groupBy: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition]
    ] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest = {
    import GetCostAndUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest
      .builder()
      .timePeriod(timePeriod.buildAwsValue())
      .granularity(granularity.unwrap)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .metrics(metrics.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        groupBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupBy)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest
      .wrap(buildAwsValue())
}
object GetCostAndUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest =
      io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest(
        timePeriodValue.editable,
        granularityValue,
        filterValue.map(value => value.editable),
        metricsValue,
        groupByValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def granularityValue: io.github.vigoo.zioaws.costexplorer.model.Granularity
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def metricsValue: List[MetricName]
    def groupByValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly]
    ]
    def nextPageTokenValue: Option[NextPageToken]
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def granularity: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.Granularity
    ] = ZIO.succeed(granularityValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def metrics: ZIO[Any, Nothing, List[MetricName]] = ZIO.succeed(metricsValue)
    def groupBy: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("groupBy", groupByValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest.ReadOnly {
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def granularityValue
        : io.github.vigoo.zioaws.costexplorer.model.Granularity =
      io.github.vigoo.zioaws.costexplorer.model.Granularity
        .wrap(impl.granularity())
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def metricsValue: List[MetricName] = impl
      .metrics()
      .asScala
      .map { item =>
        item: MetricName
      }
      .toList
    override def groupByValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly]
    ] = scala
      .Option(impl.groupBy())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageRequest.ReadOnly =
    new Wrapper(impl)
}
