package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReservationPurchaseRecommendationDetail(
    accountId: Option[GenericString] = None,
    instanceDetails: Option[
      io.github.vigoo.zioaws.costexplorer.model.InstanceDetails
    ] = None,
    recommendedNumberOfInstancesToPurchase: Option[GenericString] = None,
    recommendedNormalizedUnitsToPurchase: Option[GenericString] = None,
    minimumNumberOfInstancesUsedPerHour: Option[GenericString] = None,
    minimumNormalizedUnitsUsedPerHour: Option[GenericString] = None,
    maximumNumberOfInstancesUsedPerHour: Option[GenericString] = None,
    maximumNormalizedUnitsUsedPerHour: Option[GenericString] = None,
    averageNumberOfInstancesUsedPerHour: Option[GenericString] = None,
    averageNormalizedUnitsUsedPerHour: Option[GenericString] = None,
    averageUtilization: Option[GenericString] = None,
    estimatedBreakEvenInMonths: Option[GenericString] = None,
    currencyCode: Option[GenericString] = None,
    estimatedMonthlySavingsAmount: Option[GenericString] = None,
    estimatedMonthlySavingsPercentage: Option[GenericString] = None,
    estimatedMonthlyOnDemandCost: Option[GenericString] = None,
    estimatedReservationCostForLookbackPeriod: Option[GenericString] = None,
    upfrontCost: Option[GenericString] = None,
    recurringStandardMonthlyCost: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail = {
    import ReservationPurchaseRecommendationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(instanceDetails.map(value => value.buildAwsValue()))(
        _.instanceDetails
      )
      .optionallyWith(
        recommendedNumberOfInstancesToPurchase.map(value =>
          value: java.lang.String
        )
      )(_.recommendedNumberOfInstancesToPurchase)
      .optionallyWith(
        recommendedNormalizedUnitsToPurchase.map(value =>
          value: java.lang.String
        )
      )(_.recommendedNormalizedUnitsToPurchase)
      .optionallyWith(
        minimumNumberOfInstancesUsedPerHour.map(value =>
          value: java.lang.String
        )
      )(_.minimumNumberOfInstancesUsedPerHour)
      .optionallyWith(
        minimumNormalizedUnitsUsedPerHour.map(value => value: java.lang.String)
      )(_.minimumNormalizedUnitsUsedPerHour)
      .optionallyWith(
        maximumNumberOfInstancesUsedPerHour.map(value =>
          value: java.lang.String
        )
      )(_.maximumNumberOfInstancesUsedPerHour)
      .optionallyWith(
        maximumNormalizedUnitsUsedPerHour.map(value => value: java.lang.String)
      )(_.maximumNormalizedUnitsUsedPerHour)
      .optionallyWith(
        averageNumberOfInstancesUsedPerHour.map(value =>
          value: java.lang.String
        )
      )(_.averageNumberOfInstancesUsedPerHour)
      .optionallyWith(
        averageNormalizedUnitsUsedPerHour.map(value => value: java.lang.String)
      )(_.averageNormalizedUnitsUsedPerHour)
      .optionallyWith(averageUtilization.map(value => value: java.lang.String))(
        _.averageUtilization
      )
      .optionallyWith(
        estimatedBreakEvenInMonths.map(value => value: java.lang.String)
      )(_.estimatedBreakEvenInMonths)
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(
        estimatedMonthlySavingsAmount.map(value => value: java.lang.String)
      )(_.estimatedMonthlySavingsAmount)
      .optionallyWith(
        estimatedMonthlySavingsPercentage.map(value => value: java.lang.String)
      )(_.estimatedMonthlySavingsPercentage)
      .optionallyWith(
        estimatedMonthlyOnDemandCost.map(value => value: java.lang.String)
      )(_.estimatedMonthlyOnDemandCost)
      .optionallyWith(
        estimatedReservationCostForLookbackPeriod.map(value =>
          value: java.lang.String
        )
      )(_.estimatedReservationCostForLookbackPeriod)
      .optionallyWith(upfrontCost.map(value => value: java.lang.String))(
        _.upfrontCost
      )
      .optionallyWith(
        recurringStandardMonthlyCost.map(value => value: java.lang.String)
      )(_.recurringStandardMonthlyCost)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail
      .wrap(buildAwsValue())
}
object ReservationPurchaseRecommendationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail =
      io.github.vigoo.zioaws.costexplorer.model
        .ReservationPurchaseRecommendationDetail(
          accountIdValue.map(value => value),
          instanceDetailsValue.map(value => value.editable),
          recommendedNumberOfInstancesToPurchaseValue.map(value => value),
          recommendedNormalizedUnitsToPurchaseValue.map(value => value),
          minimumNumberOfInstancesUsedPerHourValue.map(value => value),
          minimumNormalizedUnitsUsedPerHourValue.map(value => value),
          maximumNumberOfInstancesUsedPerHourValue.map(value => value),
          maximumNormalizedUnitsUsedPerHourValue.map(value => value),
          averageNumberOfInstancesUsedPerHourValue.map(value => value),
          averageNormalizedUnitsUsedPerHourValue.map(value => value),
          averageUtilizationValue.map(value => value),
          estimatedBreakEvenInMonthsValue.map(value => value),
          currencyCodeValue.map(value => value),
          estimatedMonthlySavingsAmountValue.map(value => value),
          estimatedMonthlySavingsPercentageValue.map(value => value),
          estimatedMonthlyOnDemandCostValue.map(value => value),
          estimatedReservationCostForLookbackPeriodValue.map(value => value),
          upfrontCostValue.map(value => value),
          recurringStandardMonthlyCostValue.map(value => value)
        )
    def accountIdValue: Option[GenericString]
    def instanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.InstanceDetails.ReadOnly
    ]
    def recommendedNumberOfInstancesToPurchaseValue: Option[GenericString]
    def recommendedNormalizedUnitsToPurchaseValue: Option[GenericString]
    def minimumNumberOfInstancesUsedPerHourValue: Option[GenericString]
    def minimumNormalizedUnitsUsedPerHourValue: Option[GenericString]
    def maximumNumberOfInstancesUsedPerHourValue: Option[GenericString]
    def maximumNormalizedUnitsUsedPerHourValue: Option[GenericString]
    def averageNumberOfInstancesUsedPerHourValue: Option[GenericString]
    def averageNormalizedUnitsUsedPerHourValue: Option[GenericString]
    def averageUtilizationValue: Option[GenericString]
    def estimatedBreakEvenInMonthsValue: Option[GenericString]
    def currencyCodeValue: Option[GenericString]
    def estimatedMonthlySavingsAmountValue: Option[GenericString]
    def estimatedMonthlySavingsPercentageValue: Option[GenericString]
    def estimatedMonthlyOnDemandCostValue: Option[GenericString]
    def estimatedReservationCostForLookbackPeriodValue: Option[GenericString]
    def upfrontCostValue: Option[GenericString]
    def recurringStandardMonthlyCostValue: Option[GenericString]
    def accountId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
    def instanceDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.InstanceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("instanceDetails", instanceDetailsValue)
    def recommendedNumberOfInstancesToPurchase
        : ZIO[Any, AwsError, GenericString] = AwsError.unwrapOptionField(
      "recommendedNumberOfInstancesToPurchase",
      recommendedNumberOfInstancesToPurchaseValue
    )
    def recommendedNormalizedUnitsToPurchase
        : ZIO[Any, AwsError, GenericString] = AwsError.unwrapOptionField(
      "recommendedNormalizedUnitsToPurchase",
      recommendedNormalizedUnitsToPurchaseValue
    )
    def minimumNumberOfInstancesUsedPerHour: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "minimumNumberOfInstancesUsedPerHour",
        minimumNumberOfInstancesUsedPerHourValue
      )
    def minimumNormalizedUnitsUsedPerHour: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "minimumNormalizedUnitsUsedPerHour",
        minimumNormalizedUnitsUsedPerHourValue
      )
    def maximumNumberOfInstancesUsedPerHour: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "maximumNumberOfInstancesUsedPerHour",
        maximumNumberOfInstancesUsedPerHourValue
      )
    def maximumNormalizedUnitsUsedPerHour: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "maximumNormalizedUnitsUsedPerHour",
        maximumNormalizedUnitsUsedPerHourValue
      )
    def averageNumberOfInstancesUsedPerHour: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "averageNumberOfInstancesUsedPerHour",
        averageNumberOfInstancesUsedPerHourValue
      )
    def averageNormalizedUnitsUsedPerHour: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "averageNormalizedUnitsUsedPerHour",
        averageNormalizedUnitsUsedPerHourValue
      )
    def averageUtilization: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("averageUtilization", averageUtilizationValue)
    def estimatedBreakEvenInMonths: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedBreakEvenInMonths",
        estimatedBreakEvenInMonthsValue
      )
    def currencyCode: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
    def estimatedMonthlySavingsAmount: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedMonthlySavingsAmount",
        estimatedMonthlySavingsAmountValue
      )
    def estimatedMonthlySavingsPercentage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedMonthlySavingsPercentage",
        estimatedMonthlySavingsPercentageValue
      )
    def estimatedMonthlyOnDemandCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "estimatedMonthlyOnDemandCost",
        estimatedMonthlyOnDemandCostValue
      )
    def estimatedReservationCostForLookbackPeriod
        : ZIO[Any, AwsError, GenericString] = AwsError.unwrapOptionField(
      "estimatedReservationCostForLookbackPeriod",
      estimatedReservationCostForLookbackPeriodValue
    )
    def upfrontCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("upfrontCost", upfrontCostValue)
    def recurringStandardMonthlyCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "recurringStandardMonthlyCost",
        recurringStandardMonthlyCostValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail
  ) extends io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail.ReadOnly {
    override def accountIdValue: Option[GenericString] =
      scala.Option(impl.accountId()).map(value => value: GenericString)
    override def instanceDetailsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.InstanceDetails.ReadOnly
    ] = scala
      .Option(impl.instanceDetails())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.InstanceDetails.wrap(value)
      )
    override def recommendedNumberOfInstancesToPurchaseValue
        : Option[GenericString] = scala
      .Option(impl.recommendedNumberOfInstancesToPurchase())
      .map(value => value: GenericString)
    override def recommendedNormalizedUnitsToPurchaseValue
        : Option[GenericString] = scala
      .Option(impl.recommendedNormalizedUnitsToPurchase())
      .map(value => value: GenericString)
    override def minimumNumberOfInstancesUsedPerHourValue
        : Option[GenericString] = scala
      .Option(impl.minimumNumberOfInstancesUsedPerHour())
      .map(value => value: GenericString)
    override def minimumNormalizedUnitsUsedPerHourValue: Option[GenericString] =
      scala
        .Option(impl.minimumNormalizedUnitsUsedPerHour())
        .map(value => value: GenericString)
    override def maximumNumberOfInstancesUsedPerHourValue
        : Option[GenericString] = scala
      .Option(impl.maximumNumberOfInstancesUsedPerHour())
      .map(value => value: GenericString)
    override def maximumNormalizedUnitsUsedPerHourValue: Option[GenericString] =
      scala
        .Option(impl.maximumNormalizedUnitsUsedPerHour())
        .map(value => value: GenericString)
    override def averageNumberOfInstancesUsedPerHourValue
        : Option[GenericString] = scala
      .Option(impl.averageNumberOfInstancesUsedPerHour())
      .map(value => value: GenericString)
    override def averageNormalizedUnitsUsedPerHourValue: Option[GenericString] =
      scala
        .Option(impl.averageNormalizedUnitsUsedPerHour())
        .map(value => value: GenericString)
    override def averageUtilizationValue: Option[GenericString] =
      scala.Option(impl.averageUtilization()).map(value => value: GenericString)
    override def estimatedBreakEvenInMonthsValue: Option[GenericString] = scala
      .Option(impl.estimatedBreakEvenInMonths())
      .map(value => value: GenericString)
    override def currencyCodeValue: Option[GenericString] =
      scala.Option(impl.currencyCode()).map(value => value: GenericString)
    override def estimatedMonthlySavingsAmountValue: Option[GenericString] =
      scala
        .Option(impl.estimatedMonthlySavingsAmount())
        .map(value => value: GenericString)
    override def estimatedMonthlySavingsPercentageValue: Option[GenericString] =
      scala
        .Option(impl.estimatedMonthlySavingsPercentage())
        .map(value => value: GenericString)
    override def estimatedMonthlyOnDemandCostValue: Option[GenericString] =
      scala
        .Option(impl.estimatedMonthlyOnDemandCost())
        .map(value => value: GenericString)
    override def estimatedReservationCostForLookbackPeriodValue
        : Option[GenericString] = scala
      .Option(impl.estimatedReservationCostForLookbackPeriod())
      .map(value => value: GenericString)
    override def upfrontCostValue: Option[GenericString] =
      scala.Option(impl.upfrontCost()).map(value => value: GenericString)
    override def recurringStandardMonthlyCostValue: Option[GenericString] =
      scala
        .Option(impl.recurringStandardMonthlyCost())
        .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationDetail
  ): io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationDetail.ReadOnly =
    new Wrapper(impl)
}
