package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NullableNonNegativeDouble,
  Arn,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AnomalySubscription(
    subscriptionArn: Option[GenericString] = None,
    accountId: Option[GenericString] = None,
    monitorArnList: Iterable[Arn],
    subscribers: Iterable[io.github.vigoo.zioaws.costexplorer.model.Subscriber],
    threshold: NullableNonNegativeDouble,
    frequency: io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency,
    subscriptionName: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.AnomalySubscription = {
    import AnomalySubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.AnomalySubscription
      .builder()
      .optionallyWith(subscriptionArn.map(value => value: java.lang.String))(
        _.subscriptionArn
      )
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .monitorArnList(monitorArnList.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .subscribers(subscribers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .threshold(threshold: java.lang.Double)
      .frequency(frequency.unwrap)
      .subscriptionName(subscriptionName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription
      .wrap(buildAwsValue())
}
object AnomalySubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.AnomalySubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription =
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription(
        subscriptionArnValue.map(value => value),
        accountIdValue.map(value => value),
        monitorArnListValue,
        subscribersValue.map { item =>
          item.editable
        },
        thresholdValue,
        frequencyValue,
        subscriptionNameValue
      )
    def subscriptionArnValue: Option[GenericString]
    def accountIdValue: Option[GenericString]
    def monitorArnListValue: List[Arn]
    def subscribersValue
        : List[io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly]
    def thresholdValue: NullableNonNegativeDouble
    def frequencyValue
        : io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency
    def subscriptionNameValue: GenericString
    def subscriptionArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("subscriptionArn", subscriptionArnValue)
    def accountId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
    def monitorArnList: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(monitorArnListValue)
    def subscribers: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly
    ]] = ZIO.succeed(subscribersValue)
    def threshold: ZIO[Any, Nothing, NullableNonNegativeDouble] =
      ZIO.succeed(thresholdValue)
    def frequency: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency
    ] = ZIO.succeed(frequencyValue)
    def subscriptionName: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(subscriptionNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.AnomalySubscription
  ) extends io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription.ReadOnly {
    override def subscriptionArnValue: Option[GenericString] =
      scala.Option(impl.subscriptionArn()).map(value => value: GenericString)
    override def accountIdValue: Option[GenericString] =
      scala.Option(impl.accountId()).map(value => value: GenericString)
    override def monitorArnListValue: List[Arn] = impl
      .monitorArnList()
      .asScala
      .map { item =>
        item: Arn
      }
      .toList
    override def subscribersValue
        : List[io.github.vigoo.zioaws.costexplorer.model.Subscriber.ReadOnly] =
      impl
        .subscribers()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.costexplorer.model.Subscriber.wrap(item)
        }
        .toList
    override def thresholdValue: NullableNonNegativeDouble =
      impl.threshold(): NullableNonNegativeDouble
    override def frequencyValue
        : io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency =
      io.github.vigoo.zioaws.costexplorer.model.AnomalySubscriptionFrequency
        .wrap(impl.frequency())
    override def subscriptionNameValue: GenericString =
      impl.subscriptionName(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.AnomalySubscription
  ): io.github.vigoo.zioaws.costexplorer.model.AnomalySubscription.ReadOnly =
    new Wrapper(impl)
}
