package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansUtilization(
    totalCommitment: Option[GenericString] = None,
    usedCommitment: Option[GenericString] = None,
    unusedCommitment: Option[GenericString] = None,
    utilizationPercentage: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization = {
    import SavingsPlansUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization
      .builder()
      .optionallyWith(totalCommitment.map(value => value: java.lang.String))(
        _.totalCommitment
      )
      .optionallyWith(usedCommitment.map(value => value: java.lang.String))(
        _.usedCommitment
      )
      .optionallyWith(unusedCommitment.map(value => value: java.lang.String))(
        _.unusedCommitment
      )
      .optionallyWith(
        utilizationPercentage.map(value => value: java.lang.String)
      )(_.utilizationPercentage)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization
      .wrap(buildAwsValue())
}
object SavingsPlansUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization(
        totalCommitmentValue.map(value => value),
        usedCommitmentValue.map(value => value),
        unusedCommitmentValue.map(value => value),
        utilizationPercentageValue.map(value => value)
      )
    def totalCommitmentValue: Option[GenericString]
    def usedCommitmentValue: Option[GenericString]
    def unusedCommitmentValue: Option[GenericString]
    def utilizationPercentageValue: Option[GenericString]
    def totalCommitment: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("totalCommitment", totalCommitmentValue)
    def usedCommitment: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("usedCommitment", usedCommitmentValue)
    def unusedCommitment: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("unusedCommitment", unusedCommitmentValue)
    def utilizationPercentage: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("utilizationPercentage", utilizationPercentageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly {
    override def totalCommitmentValue: Option[GenericString] =
      scala.Option(impl.totalCommitment()).map(value => value: GenericString)
    override def usedCommitmentValue: Option[GenericString] =
      scala.Option(impl.usedCommitment()).map(value => value: GenericString)
    override def unusedCommitmentValue: Option[GenericString] =
      scala.Option(impl.unusedCommitment()).map(value => value: GenericString)
    override def utilizationPercentageValue: Option[GenericString] = scala
      .Option(impl.utilizationPercentage())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly =
    new Wrapper(impl)
}
