package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansDetails(
    region: Option[GenericString] = None,
    instanceFamily: Option[GenericString] = None,
    offeringId: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails = {
    import SavingsPlansDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails
      .builder()
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(offeringId.map(value => value: java.lang.String))(
        _.offeringId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails
      .wrap(buildAwsValue())
}
object SavingsPlansDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails(
        regionValue.map(value => value),
        instanceFamilyValue.map(value => value),
        offeringIdValue.map(value => value)
      )
    def regionValue: Option[GenericString]
    def instanceFamilyValue: Option[GenericString]
    def offeringIdValue: Option[GenericString]
    def region: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("region", regionValue)
    def instanceFamily: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamilyValue)
    def offeringId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("offeringId", offeringIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails.ReadOnly {
    override def regionValue: Option[GenericString] =
      scala.Option(impl.region()).map(value => value: GenericString)
    override def instanceFamilyValue: Option[GenericString] =
      scala.Option(impl.instanceFamily()).map(value => value: GenericString)
    override def offeringIdValue: Option[GenericString] =
      scala.Option(impl.offeringId()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansDetails
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansDetails.ReadOnly =
    new Wrapper(impl)
}
