package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansCoverageData(
    spendCoveredBySavingsPlans: Option[GenericString] = None,
    onDemandCost: Option[GenericString] = None,
    totalCost: Option[GenericString] = None,
    coveragePercentage: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverageData = {
    import SavingsPlansCoverageData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverageData
      .builder()
      .optionallyWith(
        spendCoveredBySavingsPlans.map(value => value: java.lang.String)
      )(_.spendCoveredBySavingsPlans)
      .optionallyWith(onDemandCost.map(value => value: java.lang.String))(
        _.onDemandCost
      )
      .optionallyWith(totalCost.map(value => value: java.lang.String))(
        _.totalCost
      )
      .optionallyWith(coveragePercentage.map(value => value: java.lang.String))(
        _.coveragePercentage
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData
      .wrap(buildAwsValue())
}
object SavingsPlansCoverageData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverageData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData(
        spendCoveredBySavingsPlansValue.map(value => value),
        onDemandCostValue.map(value => value),
        totalCostValue.map(value => value),
        coveragePercentageValue.map(value => value)
      )
    def spendCoveredBySavingsPlansValue: Option[GenericString]
    def onDemandCostValue: Option[GenericString]
    def totalCostValue: Option[GenericString]
    def coveragePercentageValue: Option[GenericString]
    def spendCoveredBySavingsPlans: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField(
        "spendCoveredBySavingsPlans",
        spendCoveredBySavingsPlansValue
      )
    def onDemandCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("onDemandCost", onDemandCostValue)
    def totalCost: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("totalCost", totalCostValue)
    def coveragePercentage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("coveragePercentage", coveragePercentageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverageData
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData.ReadOnly {
    override def spendCoveredBySavingsPlansValue: Option[GenericString] = scala
      .Option(impl.spendCoveredBySavingsPlans())
      .map(value => value: GenericString)
    override def onDemandCostValue: Option[GenericString] =
      scala.Option(impl.onDemandCost()).map(value => value: GenericString)
    override def totalCostValue: Option[GenericString] =
      scala.Option(impl.totalCost()).map(value => value: GenericString)
    override def coveragePercentageValue: Option[GenericString] =
      scala.Option(impl.coveragePercentage()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverageData
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData.ReadOnly =
    new Wrapper(impl)
}
