package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RootCause(
    service: Option[GenericString] = None,
    region: Option[GenericString] = None,
    linkedAccount: Option[GenericString] = None,
    usageType: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.RootCause = {
    import RootCause.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RootCause
      .builder()
      .optionallyWith(service.map(value => value: java.lang.String))(_.service)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(linkedAccount.map(value => value: java.lang.String))(
        _.linkedAccount
      )
      .optionallyWith(usageType.map(value => value: java.lang.String))(
        _.usageType
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.costexplorer.model.RootCause.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.RootCause.wrap(buildAwsValue())
}
object RootCause {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.RootCause
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.RootCause =
      io.github.vigoo.zioaws.costexplorer.model.RootCause(
        serviceValue.map(value => value),
        regionValue.map(value => value),
        linkedAccountValue.map(value => value),
        usageTypeValue.map(value => value)
      )
    def serviceValue: Option[GenericString]
    def regionValue: Option[GenericString]
    def linkedAccountValue: Option[GenericString]
    def usageTypeValue: Option[GenericString]
    def service: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("service", serviceValue)
    def region: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("region", regionValue)
    def linkedAccount: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("linkedAccount", linkedAccountValue)
    def usageType: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("usageType", usageTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.RootCause
  ) extends io.github.vigoo.zioaws.costexplorer.model.RootCause.ReadOnly {
    override def serviceValue: Option[GenericString] =
      scala.Option(impl.service()).map(value => value: GenericString)
    override def regionValue: Option[GenericString] =
      scala.Option(impl.region()).map(value => value: GenericString)
    override def linkedAccountValue: Option[GenericString] =
      scala.Option(impl.linkedAccount()).map(value => value: GenericString)
    override def usageTypeValue: Option[GenericString] =
      scala.Option(impl.usageType()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.RootCause
  ): io.github.vigoo.zioaws.costexplorer.model.RootCause.ReadOnly = new Wrapper(
    impl
  )
}
