package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RightsizingRecommendationMetadata(
    recommendationId: Option[GenericString] = None,
    generationTimestamp: Option[GenericString] = None,
    lookbackPeriodInDays: Option[
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = None,
    additionalMetadata: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata = {
    import RightsizingRecommendationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata
      .builder()
      .optionallyWith(recommendationId.map(value => value: java.lang.String))(
        _.recommendationId
      )
      .optionallyWith(
        generationTimestamp.map(value => value: java.lang.String)
      )(_.generationTimestamp)
      .optionallyWith(lookbackPeriodInDays.map(value => value.unwrap))(
        _.lookbackPeriodInDays
      )
      .optionallyWith(additionalMetadata.map(value => value: java.lang.String))(
        _.additionalMetadata
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata
      .wrap(buildAwsValue())
}
object RightsizingRecommendationMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata =
      io.github.vigoo.zioaws.costexplorer.model
        .RightsizingRecommendationMetadata(
          recommendationIdValue.map(value => value),
          generationTimestampValue.map(value => value),
          lookbackPeriodInDaysValue.map(value => value),
          additionalMetadataValue.map(value => value)
        )
    def recommendationIdValue: Option[GenericString]
    def generationTimestampValue: Option[GenericString]
    def lookbackPeriodInDaysValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays]
    def additionalMetadataValue: Option[GenericString]
    def recommendationId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("recommendationId", recommendationIdValue)
    def generationTimestamp: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("generationTimestamp", generationTimestampValue)
    def lookbackPeriodInDays: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = AwsError.unwrapOptionField(
      "lookbackPeriodInDays",
      lookbackPeriodInDaysValue
    )
    def additionalMetadata: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("additionalMetadata", additionalMetadataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata
  ) extends io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata.ReadOnly {
    override def recommendationIdValue: Option[GenericString] =
      scala.Option(impl.recommendationId()).map(value => value: GenericString)
    override def generationTimestampValue: Option[GenericString] = scala
      .Option(impl.generationTimestamp())
      .map(value => value: GenericString)
    override def lookbackPeriodInDaysValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = scala
      .Option(impl.lookbackPeriodInDays())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
          .wrap(value)
      )
    override def additionalMetadataValue: Option[GenericString] =
      scala.Option(impl.additionalMetadata()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata
  ): io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationMetadata.ReadOnly =
    new Wrapper(impl)
}
