package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericBoolean
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RightsizingRecommendationConfiguration(
    recommendationTarget: io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget,
    benefitsConsidered: GenericBoolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration = {
    import RightsizingRecommendationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration
      .builder()
      .recommendationTarget(recommendationTarget.unwrap)
      .benefitsConsidered(benefitsConsidered: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration
      .wrap(buildAwsValue())
}
object RightsizingRecommendationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration =
      io.github.vigoo.zioaws.costexplorer.model
        .RightsizingRecommendationConfiguration(
          recommendationTargetValue,
          benefitsConsideredValue
        )
    def recommendationTargetValue
        : io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget
    def benefitsConsideredValue: GenericBoolean
    def recommendationTarget: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget
    ] = ZIO.succeed(recommendationTargetValue)
    def benefitsConsidered: ZIO[Any, Nothing, GenericBoolean] =
      ZIO.succeed(benefitsConsideredValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration
  ) extends io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly {
    override def recommendationTargetValue
        : io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget =
      io.github.vigoo.zioaws.costexplorer.model.RecommendationTarget
        .wrap(impl.recommendationTarget())
    override def benefitsConsideredValue: GenericBoolean =
      impl.benefitsConsidered(): GenericBoolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration
  ): io.github.vigoo.zioaws.costexplorer.model.RightsizingRecommendationConfiguration.ReadOnly =
    new Wrapper(impl)
}
