package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReservationPurchaseRecommendationMetadata(
    recommendationId: Option[GenericString] = None,
    generationTimestamp: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata = {
    import ReservationPurchaseRecommendationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata
      .builder()
      .optionallyWith(recommendationId.map(value => value: java.lang.String))(
        _.recommendationId
      )
      .optionallyWith(
        generationTimestamp.map(value => value: java.lang.String)
      )(_.generationTimestamp)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata
      .wrap(buildAwsValue())
}
object ReservationPurchaseRecommendationMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata =
      io.github.vigoo.zioaws.costexplorer.model
        .ReservationPurchaseRecommendationMetadata(
          recommendationIdValue.map(value => value),
          generationTimestampValue.map(value => value)
        )
    def recommendationIdValue: Option[GenericString]
    def generationTimestampValue: Option[GenericString]
    def recommendationId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("recommendationId", recommendationIdValue)
    def generationTimestamp: ZIO[Any, AwsError, GenericString] = AwsError
      .unwrapOptionField("generationTimestamp", generationTimestampValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata
  ) extends io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata.ReadOnly {
    override def recommendationIdValue: Option[GenericString] =
      scala.Option(impl.recommendationId()).map(value => value: GenericString)
    override def generationTimestampValue: Option[GenericString] = scala
      .Option(impl.generationTimestamp())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata
  ): io.github.vigoo.zioaws.costexplorer.model.ReservationPurchaseRecommendationMetadata.ReadOnly =
    new Wrapper(impl)
}
