package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  UtilizationPercentage,
  TotalActualHours,
  AmortizedRecurringFee,
  UnusedHours,
  NetRISavings,
  TotalPotentialRISavings,
  RICostForUnusedHours,
  TotalAmortizedFee,
  UnusedUnits,
  RealizedSavings,
  TotalActualUnits,
  UnrealizedSavings,
  AmortizedUpfrontFee,
  UtilizationPercentageInUnits,
  OnDemandCostOfRIHoursUsed,
  PurchasedHours,
  PurchasedUnits
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReservationAggregates(
    utilizationPercentage: Option[UtilizationPercentage] = None,
    utilizationPercentageInUnits: Option[UtilizationPercentageInUnits] = None,
    purchasedHours: Option[PurchasedHours] = None,
    purchasedUnits: Option[PurchasedUnits] = None,
    totalActualHours: Option[TotalActualHours] = None,
    totalActualUnits: Option[TotalActualUnits] = None,
    unusedHours: Option[UnusedHours] = None,
    unusedUnits: Option[UnusedUnits] = None,
    onDemandCostOfRIHoursUsed: Option[OnDemandCostOfRIHoursUsed] = None,
    netRISavings: Option[NetRISavings] = None,
    totalPotentialRISavings: Option[TotalPotentialRISavings] = None,
    amortizedUpfrontFee: Option[AmortizedUpfrontFee] = None,
    amortizedRecurringFee: Option[AmortizedRecurringFee] = None,
    totalAmortizedFee: Option[TotalAmortizedFee] = None,
    riCostForUnusedHours: Option[RICostForUnusedHours] = None,
    realizedSavings: Option[RealizedSavings] = None,
    unrealizedSavings: Option[UnrealizedSavings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ReservationAggregates = {
    import ReservationAggregates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationAggregates
      .builder()
      .optionallyWith(
        utilizationPercentage.map(value => value: java.lang.String)
      )(_.utilizationPercentage)
      .optionallyWith(
        utilizationPercentageInUnits.map(value => value: java.lang.String)
      )(_.utilizationPercentageInUnits)
      .optionallyWith(purchasedHours.map(value => value: java.lang.String))(
        _.purchasedHours
      )
      .optionallyWith(purchasedUnits.map(value => value: java.lang.String))(
        _.purchasedUnits
      )
      .optionallyWith(totalActualHours.map(value => value: java.lang.String))(
        _.totalActualHours
      )
      .optionallyWith(totalActualUnits.map(value => value: java.lang.String))(
        _.totalActualUnits
      )
      .optionallyWith(unusedHours.map(value => value: java.lang.String))(
        _.unusedHours
      )
      .optionallyWith(unusedUnits.map(value => value: java.lang.String))(
        _.unusedUnits
      )
      .optionallyWith(
        onDemandCostOfRIHoursUsed.map(value => value: java.lang.String)
      )(_.onDemandCostOfRIHoursUsed)
      .optionallyWith(netRISavings.map(value => value: java.lang.String))(
        _.netRISavings
      )
      .optionallyWith(
        totalPotentialRISavings.map(value => value: java.lang.String)
      )(_.totalPotentialRISavings)
      .optionallyWith(
        amortizedUpfrontFee.map(value => value: java.lang.String)
      )(_.amortizedUpfrontFee)
      .optionallyWith(
        amortizedRecurringFee.map(value => value: java.lang.String)
      )(_.amortizedRecurringFee)
      .optionallyWith(totalAmortizedFee.map(value => value: java.lang.String))(
        _.totalAmortizedFee
      )
      .optionallyWith(
        riCostForUnusedHours.map(value => value: java.lang.String)
      )(_.riCostForUnusedHours)
      .optionallyWith(realizedSavings.map(value => value: java.lang.String))(
        _.realizedSavings
      )
      .optionallyWith(unrealizedSavings.map(value => value: java.lang.String))(
        _.unrealizedSavings
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates
      .wrap(buildAwsValue())
}
object ReservationAggregates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ReservationAggregates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates =
      io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates(
        utilizationPercentageValue.map(value => value),
        utilizationPercentageInUnitsValue.map(value => value),
        purchasedHoursValue.map(value => value),
        purchasedUnitsValue.map(value => value),
        totalActualHoursValue.map(value => value),
        totalActualUnitsValue.map(value => value),
        unusedHoursValue.map(value => value),
        unusedUnitsValue.map(value => value),
        onDemandCostOfRIHoursUsedValue.map(value => value),
        netRISavingsValue.map(value => value),
        totalPotentialRISavingsValue.map(value => value),
        amortizedUpfrontFeeValue.map(value => value),
        amortizedRecurringFeeValue.map(value => value),
        totalAmortizedFeeValue.map(value => value),
        riCostForUnusedHoursValue.map(value => value),
        realizedSavingsValue.map(value => value),
        unrealizedSavingsValue.map(value => value)
      )
    def utilizationPercentageValue: Option[UtilizationPercentage]
    def utilizationPercentageInUnitsValue: Option[UtilizationPercentageInUnits]
    def purchasedHoursValue: Option[PurchasedHours]
    def purchasedUnitsValue: Option[PurchasedUnits]
    def totalActualHoursValue: Option[TotalActualHours]
    def totalActualUnitsValue: Option[TotalActualUnits]
    def unusedHoursValue: Option[UnusedHours]
    def unusedUnitsValue: Option[UnusedUnits]
    def onDemandCostOfRIHoursUsedValue: Option[OnDemandCostOfRIHoursUsed]
    def netRISavingsValue: Option[NetRISavings]
    def totalPotentialRISavingsValue: Option[TotalPotentialRISavings]
    def amortizedUpfrontFeeValue: Option[AmortizedUpfrontFee]
    def amortizedRecurringFeeValue: Option[AmortizedRecurringFee]
    def totalAmortizedFeeValue: Option[TotalAmortizedFee]
    def riCostForUnusedHoursValue: Option[RICostForUnusedHours]
    def realizedSavingsValue: Option[RealizedSavings]
    def unrealizedSavingsValue: Option[UnrealizedSavings]
    def utilizationPercentage: ZIO[Any, AwsError, UtilizationPercentage] =
      AwsError.unwrapOptionField(
        "utilizationPercentage",
        utilizationPercentageValue
      )
    def utilizationPercentageInUnits
        : ZIO[Any, AwsError, UtilizationPercentageInUnits] =
      AwsError.unwrapOptionField(
        "utilizationPercentageInUnits",
        utilizationPercentageInUnitsValue
      )
    def purchasedHours: ZIO[Any, AwsError, PurchasedHours] =
      AwsError.unwrapOptionField("purchasedHours", purchasedHoursValue)
    def purchasedUnits: ZIO[Any, AwsError, PurchasedUnits] =
      AwsError.unwrapOptionField("purchasedUnits", purchasedUnitsValue)
    def totalActualHours: ZIO[Any, AwsError, TotalActualHours] =
      AwsError.unwrapOptionField("totalActualHours", totalActualHoursValue)
    def totalActualUnits: ZIO[Any, AwsError, TotalActualUnits] =
      AwsError.unwrapOptionField("totalActualUnits", totalActualUnitsValue)
    def unusedHours: ZIO[Any, AwsError, UnusedHours] =
      AwsError.unwrapOptionField("unusedHours", unusedHoursValue)
    def unusedUnits: ZIO[Any, AwsError, UnusedUnits] =
      AwsError.unwrapOptionField("unusedUnits", unusedUnitsValue)
    def onDemandCostOfRIHoursUsed
        : ZIO[Any, AwsError, OnDemandCostOfRIHoursUsed] =
      AwsError.unwrapOptionField(
        "onDemandCostOfRIHoursUsed",
        onDemandCostOfRIHoursUsedValue
      )
    def netRISavings: ZIO[Any, AwsError, NetRISavings] =
      AwsError.unwrapOptionField("netRISavings", netRISavingsValue)
    def totalPotentialRISavings: ZIO[Any, AwsError, TotalPotentialRISavings] =
      AwsError.unwrapOptionField(
        "totalPotentialRISavings",
        totalPotentialRISavingsValue
      )
    def amortizedUpfrontFee: ZIO[Any, AwsError, AmortizedUpfrontFee] = AwsError
      .unwrapOptionField("amortizedUpfrontFee", amortizedUpfrontFeeValue)
    def amortizedRecurringFee: ZIO[Any, AwsError, AmortizedRecurringFee] =
      AwsError.unwrapOptionField(
        "amortizedRecurringFee",
        amortizedRecurringFeeValue
      )
    def totalAmortizedFee: ZIO[Any, AwsError, TotalAmortizedFee] =
      AwsError.unwrapOptionField("totalAmortizedFee", totalAmortizedFeeValue)
    def riCostForUnusedHours: ZIO[Any, AwsError, RICostForUnusedHours] =
      AwsError.unwrapOptionField(
        "riCostForUnusedHours",
        riCostForUnusedHoursValue
      )
    def realizedSavings: ZIO[Any, AwsError, RealizedSavings] =
      AwsError.unwrapOptionField("realizedSavings", realizedSavingsValue)
    def unrealizedSavings: ZIO[Any, AwsError, UnrealizedSavings] =
      AwsError.unwrapOptionField("unrealizedSavings", unrealizedSavingsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationAggregates
  ) extends io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly {
    override def utilizationPercentageValue: Option[UtilizationPercentage] =
      scala
        .Option(impl.utilizationPercentage())
        .map(value => value: UtilizationPercentage)
    override def utilizationPercentageInUnitsValue
        : Option[UtilizationPercentageInUnits] = scala
      .Option(impl.utilizationPercentageInUnits())
      .map(value => value: UtilizationPercentageInUnits)
    override def purchasedHoursValue: Option[PurchasedHours] =
      scala.Option(impl.purchasedHours()).map(value => value: PurchasedHours)
    override def purchasedUnitsValue: Option[PurchasedUnits] =
      scala.Option(impl.purchasedUnits()).map(value => value: PurchasedUnits)
    override def totalActualHoursValue: Option[TotalActualHours] = scala
      .Option(impl.totalActualHours())
      .map(value => value: TotalActualHours)
    override def totalActualUnitsValue: Option[TotalActualUnits] = scala
      .Option(impl.totalActualUnits())
      .map(value => value: TotalActualUnits)
    override def unusedHoursValue: Option[UnusedHours] =
      scala.Option(impl.unusedHours()).map(value => value: UnusedHours)
    override def unusedUnitsValue: Option[UnusedUnits] =
      scala.Option(impl.unusedUnits()).map(value => value: UnusedUnits)
    override def onDemandCostOfRIHoursUsedValue
        : Option[OnDemandCostOfRIHoursUsed] = scala
      .Option(impl.onDemandCostOfRIHoursUsed())
      .map(value => value: OnDemandCostOfRIHoursUsed)
    override def netRISavingsValue: Option[NetRISavings] =
      scala.Option(impl.netRISavings()).map(value => value: NetRISavings)
    override def totalPotentialRISavingsValue: Option[TotalPotentialRISavings] =
      scala
        .Option(impl.totalPotentialRISavings())
        .map(value => value: TotalPotentialRISavings)
    override def amortizedUpfrontFeeValue: Option[AmortizedUpfrontFee] = scala
      .Option(impl.amortizedUpfrontFee())
      .map(value => value: AmortizedUpfrontFee)
    override def amortizedRecurringFeeValue: Option[AmortizedRecurringFee] =
      scala
        .Option(impl.amortizedRecurringFee())
        .map(value => value: AmortizedRecurringFee)
    override def totalAmortizedFeeValue: Option[TotalAmortizedFee] = scala
      .Option(impl.totalAmortizedFee())
      .map(value => value: TotalAmortizedFee)
    override def riCostForUnusedHoursValue: Option[RICostForUnusedHours] = scala
      .Option(impl.riCostForUnusedHours())
      .map(value => value: RICostForUnusedHours)
    override def realizedSavingsValue: Option[RealizedSavings] =
      scala.Option(impl.realizedSavings()).map(value => value: RealizedSavings)
    override def unrealizedSavingsValue: Option[UnrealizedSavings] = scala
      .Option(impl.unrealizedSavings())
      .map(value => value: UnrealizedSavings)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ReservationAggregates
  ): io.github.vigoo.zioaws.costexplorer.model.ReservationAggregates.ReadOnly =
    new Wrapper(impl)
}
