package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProvideAnomalyFeedbackRequest(
    anomalyId: GenericString,
    feedback: io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest = {
    import ProvideAnomalyFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest
      .builder()
      .anomalyId(anomalyId: java.lang.String)
      .feedback(feedback.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest
      .wrap(buildAwsValue())
}
object ProvideAnomalyFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .ProvideAnomalyFeedbackRequest(anomalyIdValue, feedbackValue)
    def anomalyIdValue: GenericString
    def feedbackValue
        : io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
    def anomalyId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(anomalyIdValue)
    def feedback: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
    ] = ZIO.succeed(feedbackValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest.ReadOnly {
    override def anomalyIdValue: GenericString = impl.anomalyId(): GenericString
    override def feedbackValue
        : io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType =
      io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
        .wrap(impl.feedback())
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest
  ): io.github.vigoo.zioaws.costexplorer.model.ProvideAnomalyFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
