package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  MetricUnit,
  MetricAmount
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricValue(
    amount: Option[MetricAmount] = None,
    unit: Option[MetricUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.MetricValue = {
    import MetricValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.MetricValue
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.String))(_.amount)
      .optionallyWith(unit.map(value => value: java.lang.String))(_.unit)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.MetricValue.wrap(buildAwsValue())
}
object MetricValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.MetricValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.MetricValue =
      io.github.vigoo.zioaws.costexplorer.model.MetricValue(
        amountValue.map(value => value),
        unitValue.map(value => value)
      )
    def amountValue: Option[MetricAmount]
    def unitValue: Option[MetricUnit]
    def amount: ZIO[Any, AwsError, MetricAmount] =
      AwsError.unwrapOptionField("amount", amountValue)
    def unit: ZIO[Any, AwsError, MetricUnit] =
      AwsError.unwrapOptionField("unit", unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.MetricValue
  ) extends io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly {
    override def amountValue: Option[MetricAmount] =
      scala.Option(impl.amount()).map(value => value: MetricAmount)
    override def unitValue: Option[MetricUnit] =
      scala.Option(impl.unit()).map(value => value: MetricUnit)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.MetricValue
  ): io.github.vigoo.zioaws.costexplorer.model.MetricValue.ReadOnly =
    new Wrapper(impl)
}
