package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait Metric {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.Metric
}
object Metric {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.Metric
  ): io.github.vigoo.zioaws.costexplorer.model.Metric = value match {
    case software.amazon.awssdk.services.costexplorer.model.Metric.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.Metric.BLENDED_COST =>
      val r = BLENDED_COST
      r
    case software.amazon.awssdk.services.costexplorer.model.Metric.UNBLENDED_COST =>
      val r = UNBLENDED_COST
      r
    case software.amazon.awssdk.services.costexplorer.model.Metric.AMORTIZED_COST =>
      val r = AMORTIZED_COST
      r
    case software.amazon.awssdk.services.costexplorer.model.Metric.NET_UNBLENDED_COST =>
      val r = NET_UNBLENDED_COST
      r
    case software.amazon.awssdk.services.costexplorer.model.Metric.NET_AMORTIZED_COST =>
      val r = NET_AMORTIZED_COST
      r
    case software.amazon.awssdk.services.costexplorer.model.Metric.USAGE_QUANTITY =>
      val r = USAGE_QUANTITY
      r
    case software.amazon.awssdk.services.costexplorer.model.Metric.NORMALIZED_USAGE_AMOUNT =>
      val r = NORMALIZED_USAGE_AMOUNT
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.Metric {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Metric =
      software.amazon.awssdk.services.costexplorer.model.Metric.UNKNOWN_TO_SDK_VERSION
  }
  case object BLENDED_COST
      extends io.github.vigoo.zioaws.costexplorer.model.Metric {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Metric =
      software.amazon.awssdk.services.costexplorer.model.Metric.BLENDED_COST
  }
  case object UNBLENDED_COST
      extends io.github.vigoo.zioaws.costexplorer.model.Metric {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Metric =
      software.amazon.awssdk.services.costexplorer.model.Metric.UNBLENDED_COST
  }
  case object AMORTIZED_COST
      extends io.github.vigoo.zioaws.costexplorer.model.Metric {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Metric =
      software.amazon.awssdk.services.costexplorer.model.Metric.AMORTIZED_COST
  }
  case object NET_UNBLENDED_COST
      extends io.github.vigoo.zioaws.costexplorer.model.Metric {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Metric =
      software.amazon.awssdk.services.costexplorer.model.Metric.NET_UNBLENDED_COST
  }
  case object NET_AMORTIZED_COST
      extends io.github.vigoo.zioaws.costexplorer.model.Metric {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Metric =
      software.amazon.awssdk.services.costexplorer.model.Metric.NET_AMORTIZED_COST
  }
  case object USAGE_QUANTITY
      extends io.github.vigoo.zioaws.costexplorer.model.Metric {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Metric =
      software.amazon.awssdk.services.costexplorer.model.Metric.USAGE_QUANTITY
  }
  case object NORMALIZED_USAGE_AMOUNT
      extends io.github.vigoo.zioaws.costexplorer.model.Metric {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.Metric =
      software.amazon.awssdk.services.costexplorer.model.Metric.NORMALIZED_USAGE_AMOUNT
  }
}
