package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCostCategoryDefinitionsResponse(
    costCategoryReferences: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference]
    ] = None,
    nextToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse = {
    import ListCostCategoryDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse
      .builder()
      .optionallyWith(
        costCategoryReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.costCategoryReferences)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListCostCategoryDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .ListCostCategoryDefinitionsResponse(
          costCategoryReferencesValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def costCategoryReferencesValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference.ReadOnly
    ]]
    def nextTokenValue: Option[NextPageToken]
    def costCategoryReferences: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "costCategoryReferences",
      costCategoryReferencesValue
    )
    def nextToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsResponse.ReadOnly {
    override def costCategoryReferencesValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference.ReadOnly
    ]] = scala
      .Option(impl.costCategoryReferences())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.CostCategoryReference
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse
  ): io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
