package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  CostCategoryMaxResults,
  NextPageToken,
  ZonedDateTime
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCostCategoryDefinitionsRequest(
    effectiveOn: Option[ZonedDateTime] = None,
    nextToken: Option[NextPageToken] = None,
    maxResults: Option[CostCategoryMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest = {
    import ListCostCategoryDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest
      .builder()
      .optionallyWith(effectiveOn.map(value => value: java.lang.String))(
        _.effectiveOn
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListCostCategoryDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .ListCostCategoryDefinitionsRequest(
          effectiveOnValue.map(value => value),
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value)
        )
    def effectiveOnValue: Option[ZonedDateTime]
    def nextTokenValue: Option[NextPageToken]
    def maxResultsValue: Option[CostCategoryMaxResults]
    def effectiveOn: ZIO[Any, AwsError, ZonedDateTime] =
      AwsError.unwrapOptionField("effectiveOn", effectiveOnValue)
    def nextToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, CostCategoryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest.ReadOnly {
    override def effectiveOnValue: Option[ZonedDateTime] =
      scala.Option(impl.effectiveOn()).map(value => value: ZonedDateTime)
    override def nextTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextToken()).map(value => value: NextPageToken)
    override def maxResultsValue: Option[CostCategoryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => value: CostCategoryMaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest
  ): io.github.vigoo.zioaws.costexplorer.model.ListCostCategoryDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
