package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GroupDefinitionKey
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GroupDefinition(
    `type`: Option[
      io.github.vigoo.zioaws.costexplorer.model.GroupDefinitionType
    ] = None,
    key: Option[GroupDefinitionKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GroupDefinition = {
    import GroupDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GroupDefinition
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GroupDefinition
      .wrap(buildAwsValue())
}
object GroupDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GroupDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.GroupDefinition =
      io.github.vigoo.zioaws.costexplorer.model.GroupDefinition(
        typeValue.map(value => value),
        keyValue.map(value => value)
      )
    def typeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.GroupDefinitionType]
    def keyValue: Option[GroupDefinitionKey]
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.GroupDefinitionType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def key: ZIO[Any, AwsError, GroupDefinitionKey] =
      AwsError.unwrapOptionField("key", keyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GroupDefinition
  ) extends io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly {
    override def typeValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.GroupDefinitionType
    ] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.GroupDefinitionType
          .wrap(value)
      )
    override def keyValue: Option[GroupDefinitionKey] =
      scala.Option(impl.key()).map(value => value: GroupDefinitionKey)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GroupDefinition
  ): io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly =
    new Wrapper(impl)
}
