package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  PageSize,
  Entity,
  NextPageToken
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetTagsResponse(
    nextPageToken: Option[NextPageToken] = None,
    tags: Iterable[Entity],
    returnSize: PageSize,
    totalSize: PageSize
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetTagsResponse = {
    import GetTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetTagsResponse
      .builder()
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .tags(tags.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .returnSize(returnSize: Integer)
      .totalSize(totalSize: Integer)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse
      .wrap(buildAwsValue())
}
object GetTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse(
        nextPageTokenValue.map(value => value),
        tagsValue,
        returnSizeValue,
        totalSizeValue
      )
    def nextPageTokenValue: Option[NextPageToken]
    def tagsValue: List[Entity]
    def returnSizeValue: PageSize
    def totalSizeValue: PageSize
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def tags: ZIO[Any, Nothing, List[Entity]] = ZIO.succeed(tagsValue)
    def returnSize: ZIO[Any, Nothing, PageSize] = ZIO.succeed(returnSizeValue)
    def totalSize: ZIO[Any, Nothing, PageSize] = ZIO.succeed(totalSizeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetTagsResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.ReadOnly {
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def tagsValue: List[Entity] = impl
      .tags()
      .asScala
      .map { item =>
        item: Entity
      }
      .toList
    override def returnSizeValue: PageSize = impl.returnSize(): PageSize
    override def totalSizeValue: PageSize = impl.totalSize(): PageSize
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetTagsResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetTagsResponse.ReadOnly =
    new Wrapper(impl)
}
