package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NextPageToken,
  MaxResults,
  TagKey,
  SearchString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetTagsRequest(
    searchString: Option[SearchString] = None,
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    tagKey: Option[TagKey] = None,
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    sortBy: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.SortDefinition]
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetTagsRequest = {
    import GetTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetTagsRequest
      .builder()
      .optionallyWith(searchString.map(value => value: java.lang.String))(
        _.searchString
      )
      .timePeriod(timePeriod.buildAwsValue())
      .optionallyWith(tagKey.map(value => value: java.lang.String))(_.tagKey)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        sortBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortBy)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest
      .wrap(buildAwsValue())
}
object GetTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest =
      io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest(
        searchStringValue.map(value => value),
        timePeriodValue.editable,
        tagKeyValue.map(value => value),
        filterValue.map(value => value.editable),
        sortByValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        maxResultsValue.map(value => value),
        nextPageTokenValue.map(value => value)
      )
    def searchStringValue: Option[SearchString]
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def tagKeyValue: Option[TagKey]
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def sortByValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly]
    ]
    def maxResultsValue: Option[MaxResults]
    def nextPageTokenValue: Option[NextPageToken]
    def searchString: ZIO[Any, AwsError, SearchString] =
      AwsError.unwrapOptionField("searchString", searchStringValue)
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def tagKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("tagKey", tagKeyValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def sortBy: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("sortBy", sortByValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetTagsRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest.ReadOnly {
    override def searchStringValue: Option[SearchString] =
      scala.Option(impl.searchString()).map(value => value: SearchString)
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def tagKeyValue: Option[TagKey] =
      scala.Option(impl.tagKey()).map(value => value: TagKey)
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def sortByValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.SortDefinition.ReadOnly]
    ] = scala
      .Option(impl.sortBy())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.SortDefinition.wrap(item)
        }.toList
      )
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetTagsRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetTagsRequest.ReadOnly =
    new Wrapper(impl)
}
