package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSavingsPlansUtilizationResponse(
    savingsPlansUtilizationsByTime: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime
    ]] = None,
    total: io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse = {
    import GetSavingsPlansUtilizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse
      .builder()
      .optionallyWith(
        savingsPlansUtilizationsByTime.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.savingsPlansUtilizationsByTime)
      .total(total.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse
      .wrap(buildAwsValue())
}
object GetSavingsPlansUtilizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .GetSavingsPlansUtilizationResponse(
          savingsPlansUtilizationsByTimeValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          totalValue.editable
        )
    def savingsPlansUtilizationsByTimeValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime.ReadOnly
    ]]
    def totalValue
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates.ReadOnly
    def savingsPlansUtilizationsByTime: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "savingsPlansUtilizationsByTime",
      savingsPlansUtilizationsByTimeValue
    )
    def total: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates.ReadOnly
    ] = ZIO.succeed(totalValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.ReadOnly {
    override def savingsPlansUtilizationsByTimeValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime.ReadOnly
    ]] = scala
      .Option(impl.savingsPlansUtilizationsByTime())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime
            .wrap(item)
        }.toList
      )
    override def totalValue
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates
        .wrap(impl.total())
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationResponse.ReadOnly =
    new Wrapper(impl)
}
