package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSavingsPlansUtilizationDetailsResponse(
    savingsPlansUtilizationDetails: Iterable[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail
    ],
    total: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates
    ] = None,
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    nextToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse = {
    import GetSavingsPlansUtilizationDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse
      .builder()
      .savingsPlansUtilizationDetails(savingsPlansUtilizationDetails.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .timePeriod(timePeriod.buildAwsValue())
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse
      .wrap(buildAwsValue())
}
object GetSavingsPlansUtilizationDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .GetSavingsPlansUtilizationDetailsResponse(
          savingsPlansUtilizationDetailsValue.map { item =>
            item.editable
          },
          totalValue.map(value => value.editable),
          timePeriodValue.editable,
          nextTokenValue.map(value => value)
        )
    def savingsPlansUtilizationDetailsValue: List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly
    ]
    def totalValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates.ReadOnly
    ]
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def nextTokenValue: Option[NextPageToken]
    def savingsPlansUtilizationDetails: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly
    ]] = ZIO.succeed(savingsPlansUtilizationDetailsValue)
    def total: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates.ReadOnly
    ] = AwsError.unwrapOptionField("total", totalValue)
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def nextToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly {
    override def savingsPlansUtilizationDetailsValue: List[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail.ReadOnly
    ] = impl
      .savingsPlansUtilizationDetails()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationDetail
          .wrap(item)
      }
      .toList
    override def totalValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates.ReadOnly
    ] = scala
      .Option(impl.total())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationAggregates
          .wrap(value)
      )
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def nextTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
