package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSavingsPlansPurchaseRecommendationResponse(
    metadata: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata
    ] = None,
    savingsPlansPurchaseRecommendation: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation
    ] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse = {
    import GetSavingsPlansPurchaseRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(
        savingsPlansPurchaseRecommendation.map(value => value.buildAwsValue())
      )(_.savingsPlansPurchaseRecommendation)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse
      .wrap(buildAwsValue())
}
object GetSavingsPlansPurchaseRecommendationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .GetSavingsPlansPurchaseRecommendationResponse(
          metadataValue.map(value => value.editable),
          savingsPlansPurchaseRecommendationValue.map(value => value.editable),
          nextPageTokenValue.map(value => value)
        )
    def metadataValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata.ReadOnly
    ]
    def savingsPlansPurchaseRecommendationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation.ReadOnly
    ]
    def nextPageTokenValue: Option[NextPageToken]
    def metadata: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadataValue)
    def savingsPlansPurchaseRecommendation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "savingsPlansPurchaseRecommendation",
      savingsPlansPurchaseRecommendationValue
    )
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly {
    override def metadataValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata.ReadOnly
    ] = scala
      .Option(impl.metadata())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendationMetadata
          .wrap(value)
      )
    override def savingsPlansPurchaseRecommendationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation.ReadOnly
    ] = scala
      .Option(impl.savingsPlansPurchaseRecommendation())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansPurchaseRecommendation
          .wrap(value)
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse.ReadOnly =
    new Wrapper(impl)
}
