package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NonNegativeInteger,
  NextPageToken
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSavingsPlansPurchaseRecommendationRequest(
    savingsPlansType: io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType,
    termInYears: io.github.vigoo.zioaws.costexplorer.model.TermInYears,
    paymentOption: io.github.vigoo.zioaws.costexplorer.model.PaymentOption,
    accountScope: Option[
      io.github.vigoo.zioaws.costexplorer.model.AccountScope
    ] = None,
    nextPageToken: Option[NextPageToken] = None,
    pageSize: Option[NonNegativeInteger] = None,
    lookbackPeriodInDays: io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays,
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest = {
    import GetSavingsPlansPurchaseRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
      .builder()
      .savingsPlansType(savingsPlansType.unwrap)
      .termInYears(termInYears.unwrap)
      .paymentOption(paymentOption.unwrap)
      .optionallyWith(accountScope.map(value => value.unwrap))(_.accountScope)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(pageSize.map(value => value: Integer))(_.pageSize)
      .lookbackPeriodInDays(lookbackPeriodInDays.unwrap)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
      .wrap(buildAwsValue())
}
object GetSavingsPlansPurchaseRecommendationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .GetSavingsPlansPurchaseRecommendationRequest(
          savingsPlansTypeValue,
          termInYearsValue,
          paymentOptionValue,
          accountScopeValue.map(value => value),
          nextPageTokenValue.map(value => value),
          pageSizeValue.map(value => value),
          lookbackPeriodInDaysValue,
          filterValue.map(value => value.editable)
        )
    def savingsPlansTypeValue
        : io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType
    def termInYearsValue: io.github.vigoo.zioaws.costexplorer.model.TermInYears
    def paymentOptionValue
        : io.github.vigoo.zioaws.costexplorer.model.PaymentOption
    def accountScopeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AccountScope]
    def nextPageTokenValue: Option[NextPageToken]
    def pageSizeValue: Option[NonNegativeInteger]
    def lookbackPeriodInDaysValue
        : io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def savingsPlansType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType
    ] = ZIO.succeed(savingsPlansTypeValue)
    def termInYears: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.TermInYears
    ] = ZIO.succeed(termInYearsValue)
    def paymentOption: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.PaymentOption
    ] = ZIO.succeed(paymentOptionValue)
    def accountScope: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.AccountScope
    ] = AwsError.unwrapOptionField("accountScope", accountScopeValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def pageSize: ZIO[Any, AwsError, NonNegativeInteger] =
      AwsError.unwrapOptionField("pageSize", pageSizeValue)
    def lookbackPeriodInDays: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = ZIO.succeed(lookbackPeriodInDaysValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest.ReadOnly {
    override def savingsPlansTypeValue
        : io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType =
      io.github.vigoo.zioaws.costexplorer.model.SupportedSavingsPlansType
        .wrap(impl.savingsPlansType())
    override def termInYearsValue
        : io.github.vigoo.zioaws.costexplorer.model.TermInYears =
      io.github.vigoo.zioaws.costexplorer.model.TermInYears
        .wrap(impl.termInYears())
    override def paymentOptionValue
        : io.github.vigoo.zioaws.costexplorer.model.PaymentOption =
      io.github.vigoo.zioaws.costexplorer.model.PaymentOption
        .wrap(impl.paymentOption())
    override def accountScopeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AccountScope] = scala
      .Option(impl.accountScope())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.AccountScope.wrap(value)
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def pageSizeValue: Option[NonNegativeInteger] =
      scala.Option(impl.pageSize()).map(value => value: NonNegativeInteger)
    override def lookbackPeriodInDaysValue
        : io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays =
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
        .wrap(impl.lookbackPeriodInDays())
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest.ReadOnly =
    new Wrapper(impl)
}
