package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NextPageToken,
  NonNegativeInteger,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetReservationPurchaseRecommendationRequest(
    accountId: Option[GenericString] = None,
    service: GenericString,
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    accountScope: Option[
      io.github.vigoo.zioaws.costexplorer.model.AccountScope
    ] = None,
    lookbackPeriodInDays: Option[
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = None,
    termInYears: Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears] =
      None,
    paymentOption: Option[
      io.github.vigoo.zioaws.costexplorer.model.PaymentOption
    ] = None,
    serviceSpecification: Option[
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification
    ] = None,
    pageSize: Option[NonNegativeInteger] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest = {
    import GetReservationPurchaseRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .service(service: java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(accountScope.map(value => value.unwrap))(_.accountScope)
      .optionallyWith(lookbackPeriodInDays.map(value => value.unwrap))(
        _.lookbackPeriodInDays
      )
      .optionallyWith(termInYears.map(value => value.unwrap))(_.termInYears)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(serviceSpecification.map(value => value.buildAwsValue()))(
        _.serviceSpecification
      )
      .optionallyWith(pageSize.map(value => value: Integer))(_.pageSize)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest
      .wrap(buildAwsValue())
}
object GetReservationPurchaseRecommendationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .GetReservationPurchaseRecommendationRequest(
          accountIdValue.map(value => value),
          serviceValue,
          filterValue.map(value => value.editable),
          accountScopeValue.map(value => value),
          lookbackPeriodInDaysValue.map(value => value),
          termInYearsValue.map(value => value),
          paymentOptionValue.map(value => value),
          serviceSpecificationValue.map(value => value.editable),
          pageSizeValue.map(value => value),
          nextPageTokenValue.map(value => value)
        )
    def accountIdValue: Option[GenericString]
    def serviceValue: GenericString
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def accountScopeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AccountScope]
    def lookbackPeriodInDaysValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays]
    def termInYearsValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears]
    def paymentOptionValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.PaymentOption]
    def serviceSpecificationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly
    ]
    def pageSizeValue: Option[NonNegativeInteger]
    def nextPageTokenValue: Option[NextPageToken]
    def accountId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
    def service: ZIO[Any, Nothing, GenericString] = ZIO.succeed(serviceValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def accountScope: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.AccountScope
    ] = AwsError.unwrapOptionField("accountScope", accountScopeValue)
    def lookbackPeriodInDays: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = AwsError.unwrapOptionField(
      "lookbackPeriodInDays",
      lookbackPeriodInDaysValue
    )
    def termInYears: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.TermInYears
    ] = AwsError.unwrapOptionField("termInYears", termInYearsValue)
    def paymentOption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.PaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def serviceSpecification: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSpecification",
      serviceSpecificationValue
    )
    def pageSize: ZIO[Any, AwsError, NonNegativeInteger] =
      AwsError.unwrapOptionField("pageSize", pageSizeValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest.ReadOnly {
    override def accountIdValue: Option[GenericString] =
      scala.Option(impl.accountId()).map(value => value: GenericString)
    override def serviceValue: GenericString = impl.service(): GenericString
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def accountScopeValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AccountScope] = scala
      .Option(impl.accountScope())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.AccountScope.wrap(value)
      )
    override def lookbackPeriodInDaysValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
    ] = scala
      .Option(impl.lookbackPeriodInDays())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.LookbackPeriodInDays
          .wrap(value)
      )
    override def termInYearsValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.TermInYears] = scala
      .Option(impl.termInYears())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.TermInYears.wrap(value)
      )
    override def paymentOptionValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.PaymentOption] =
      scala
        .Option(impl.paymentOption())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.PaymentOption.wrap(value)
        )
    override def serviceSpecificationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification.ReadOnly
    ] = scala
      .Option(impl.serviceSpecification())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.ServiceSpecification
          .wrap(value)
      )
    override def pageSizeValue: Option[NonNegativeInteger] =
      scala.Option(impl.pageSize()).map(value => value: NonNegativeInteger)
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetReservationPurchaseRecommendationRequest.ReadOnly =
    new Wrapper(impl)
}
