package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.PredictionIntervalLevel
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCostForecastRequest(
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    metric: io.github.vigoo.zioaws.costexplorer.model.Metric,
    granularity: io.github.vigoo.zioaws.costexplorer.model.Granularity,
    filter: Option[io.github.vigoo.zioaws.costexplorer.model.Expression] = None,
    predictionIntervalLevel: Option[PredictionIntervalLevel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest = {
    import GetCostForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest
      .builder()
      .timePeriod(timePeriod.buildAwsValue())
      .metric(metric.unwrap)
      .granularity(granularity.unwrap)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(predictionIntervalLevel.map(value => value: Integer))(
        _.predictionIntervalLevel
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest
      .wrap(buildAwsValue())
}
object GetCostForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest =
      io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest(
        timePeriodValue.editable,
        metricValue,
        granularityValue,
        filterValue.map(value => value.editable),
        predictionIntervalLevelValue.map(value => value)
      )
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def metricValue: io.github.vigoo.zioaws.costexplorer.model.Metric
    def granularityValue: io.github.vigoo.zioaws.costexplorer.model.Granularity
    def filterValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def predictionIntervalLevelValue: Option[PredictionIntervalLevel]
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def metric
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.costexplorer.model.Metric] =
      ZIO.succeed(metricValue)
    def granularity: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.Granularity
    ] = ZIO.succeed(granularityValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def predictionIntervalLevel: ZIO[Any, AwsError, PredictionIntervalLevel] =
      AwsError.unwrapOptionField(
        "predictionIntervalLevel",
        predictionIntervalLevelValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest.ReadOnly {
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def metricValue: io.github.vigoo.zioaws.costexplorer.model.Metric =
      io.github.vigoo.zioaws.costexplorer.model.Metric.wrap(impl.metric())
    override def granularityValue
        : io.github.vigoo.zioaws.costexplorer.model.Granularity =
      io.github.vigoo.zioaws.costexplorer.model.Granularity
        .wrap(impl.granularity())
    override def filterValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def predictionIntervalLevelValue: Option[PredictionIntervalLevel] =
      scala
        .Option(impl.predictionIntervalLevel())
        .map(value => value: PredictionIntervalLevel)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetCostForecastRequest.ReadOnly =
    new Wrapper(impl)
}
