package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  PageSize,
  CostCategoryValue,
  CostCategoryName,
  NextPageToken
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCostCategoriesResponse(
    nextPageToken: Option[NextPageToken] = None,
    costCategoryNames: Option[Iterable[CostCategoryName]] = None,
    costCategoryValues: Option[Iterable[CostCategoryValue]] = None,
    returnSize: PageSize,
    totalSize: PageSize
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse = {
    import GetCostCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse
      .builder()
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(
        costCategoryNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.costCategoryNames)
      .optionallyWith(
        costCategoryValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.costCategoryValues)
      .returnSize(returnSize: Integer)
      .totalSize(totalSize: Integer)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse
      .wrap(buildAwsValue())
}
object GetCostCategoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse(
        nextPageTokenValue.map(value => value),
        costCategoryNamesValue.map(value => value),
        costCategoryValuesValue.map(value => value),
        returnSizeValue,
        totalSizeValue
      )
    def nextPageTokenValue: Option[NextPageToken]
    def costCategoryNamesValue: Option[List[CostCategoryName]]
    def costCategoryValuesValue: Option[List[CostCategoryValue]]
    def returnSizeValue: PageSize
    def totalSizeValue: PageSize
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def costCategoryNames: ZIO[Any, AwsError, List[CostCategoryName]] =
      AwsError.unwrapOptionField("costCategoryNames", costCategoryNamesValue)
    def costCategoryValues: ZIO[Any, AwsError, List[CostCategoryValue]] =
      AwsError.unwrapOptionField("costCategoryValues", costCategoryValuesValue)
    def returnSize: ZIO[Any, Nothing, PageSize] = ZIO.succeed(returnSizeValue)
    def totalSize: ZIO[Any, Nothing, PageSize] = ZIO.succeed(totalSizeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.ReadOnly {
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def costCategoryNamesValue: Option[List[CostCategoryName]] = scala
      .Option(impl.costCategoryNames())
      .map(value =>
        value.asScala.map { item =>
          item: CostCategoryName
        }.toList
      )
    override def costCategoryValuesValue: Option[List[CostCategoryValue]] =
      scala
        .Option(impl.costCategoryValues())
        .map(value =>
          value.asScala.map { item =>
            item: CostCategoryValue
          }.toList
        )
    override def returnSizeValue: PageSize = impl.returnSize(): PageSize
    override def totalSizeValue: PageSize = impl.totalSize(): PageSize
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetCostCategoriesResponse.ReadOnly =
    new Wrapper(impl)
}
