package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NextPageToken,
  MetricName
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCostAndUsageWithResourcesRequest(
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    granularity: io.github.vigoo.zioaws.costexplorer.model.Granularity,
    filter: io.github.vigoo.zioaws.costexplorer.model.Expression,
    metrics: Option[Iterable[MetricName]] = None,
    groupBy: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition]
    ] = None,
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest = {
    import GetCostAndUsageWithResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest
      .builder()
      .timePeriod(timePeriod.buildAwsValue())
      .granularity(granularity.unwrap)
      .filter(filter.buildAwsValue())
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        groupBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupBy)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest
      .wrap(buildAwsValue())
}
object GetCostAndUsageWithResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .GetCostAndUsageWithResourcesRequest(
          timePeriodValue.editable,
          granularityValue,
          filterValue.editable,
          metricsValue.map(value => value),
          groupByValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value)
        )
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def granularityValue: io.github.vigoo.zioaws.costexplorer.model.Granularity
    def filterValue
        : io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    def metricsValue: Option[List[MetricName]]
    def groupByValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly]
    ]
    def nextPageTokenValue: Option[NextPageToken]
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def granularity: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.Granularity
    ] = ZIO.succeed(granularityValue)
    def filter: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = ZIO.succeed(filterValue)
    def metrics: ZIO[Any, AwsError, List[MetricName]] =
      AwsError.unwrapOptionField("metrics", metricsValue)
    def groupBy: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("groupBy", groupByValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest.ReadOnly {
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def granularityValue
        : io.github.vigoo.zioaws.costexplorer.model.Granularity =
      io.github.vigoo.zioaws.costexplorer.model.Granularity
        .wrap(impl.granularity())
    override def filterValue
        : io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(impl.filter())
    override def metricsValue: Option[List[MetricName]] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          item: MetricName
        }.toList
      )
    override def groupByValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.ReadOnly]
    ] = scala
      .Option(impl.groupBy())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.GroupDefinition.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetCostAndUsageWithResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
