package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  PageSize,
  NextPageToken,
  GenericString,
  Value
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAnomalySubscriptionsRequest(
    subscriptionArnList: Option[Iterable[Value]] = None,
    monitorArn: Option[GenericString] = None,
    nextPageToken: Option[NextPageToken] = None,
    maxResults: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest = {
    import GetAnomalySubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest
      .builder()
      .optionallyWith(
        subscriptionArnList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subscriptionArnList)
      .optionallyWith(monitorArn.map(value => value: java.lang.String))(
        _.monitorArn
      )
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest
      .wrap(buildAwsValue())
}
object GetAnomalySubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest =
      io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest(
        subscriptionArnListValue.map(value => value),
        monitorArnValue.map(value => value),
        nextPageTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def subscriptionArnListValue: Option[List[Value]]
    def monitorArnValue: Option[GenericString]
    def nextPageTokenValue: Option[NextPageToken]
    def maxResultsValue: Option[PageSize]
    def subscriptionArnList: ZIO[Any, AwsError, List[Value]] = AwsError
      .unwrapOptionField("subscriptionArnList", subscriptionArnListValue)
    def monitorArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("monitorArn", monitorArnValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def maxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest.ReadOnly {
    override def subscriptionArnListValue: Option[List[Value]] = scala
      .Option(impl.subscriptionArnList())
      .map(value =>
        value.asScala.map { item =>
          item: Value
        }.toList
      )
    override def monitorArnValue: Option[GenericString] =
      scala.Option(impl.monitorArn()).map(value => value: GenericString)
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
    override def maxResultsValue: Option[PageSize] =
      scala.Option(impl.maxResults()).map(value => value: PageSize)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest
  ): io.github.vigoo.zioaws.costexplorer.model.GetAnomalySubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
