package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCostCategoryDefinitionResponse(
    costCategory: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategory
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse = {
    import DescribeCostCategoryDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse
      .builder()
      .optionallyWith(costCategory.map(value => value.buildAwsValue()))(
        _.costCategory
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse
      .wrap(buildAwsValue())
}
object DescribeCostCategoryDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .DescribeCostCategoryDefinitionResponse(
          costCategoryValue.map(value => value.editable)
        )
    def costCategoryValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategory.ReadOnly
    ]
    def costCategory: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CostCategory.ReadOnly
    ] = AwsError.unwrapOptionField("costCategory", costCategoryValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.ReadOnly {
    override def costCategoryValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategory.ReadOnly
    ] = scala
      .Option(impl.costCategory())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategory.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse
  ): io.github.vigoo.zioaws.costexplorer.model.DescribeCostCategoryDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
