package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAnomalySubscriptionRequest(
    subscriptionArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest = {
    import DeleteAnomalySubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest
      .builder()
      .subscriptionArn(subscriptionArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest
      .wrap(buildAwsValue())
}
object DeleteAnomalySubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .DeleteAnomalySubscriptionRequest(subscriptionArnValue)
    def subscriptionArnValue: GenericString
    def subscriptionArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(subscriptionArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest.ReadOnly {
    override def subscriptionArnValue: GenericString =
      impl.subscriptionArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest
  ): io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalySubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
