package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAnomalyMonitorRequest(monitorArn: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest = {
    import DeleteAnomalyMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest
      .builder()
      .monitorArn(monitorArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest
      .wrap(buildAwsValue())
}
object DeleteAnomalyMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest =
      io.github.vigoo.zioaws.costexplorer.model
        .DeleteAnomalyMonitorRequest(monitorArnValue)
    def monitorArnValue: GenericString
    def monitorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(monitorArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest
  ) extends io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest.ReadOnly {
    override def monitorArnValue: GenericString =
      impl.monitorArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest
  ): io.github.vigoo.zioaws.costexplorer.model.DeleteAnomalyMonitorRequest.ReadOnly =
    new Wrapper(impl)
}
