package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CoverageByTime(
    timePeriod: Option[io.github.vigoo.zioaws.costexplorer.model.DateInterval] =
      None,
    groups: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup
    ]] = None,
    total: Option[io.github.vigoo.zioaws.costexplorer.model.Coverage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CoverageByTime = {
    import CoverageByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CoverageByTime
      .builder()
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CoverageByTime.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CoverageByTime
      .wrap(buildAwsValue())
}
object CoverageByTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CoverageByTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.CoverageByTime =
      io.github.vigoo.zioaws.costexplorer.model.CoverageByTime(
        timePeriodValue.map(value => value.editable),
        groupsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        totalValue.map(value => value.editable)
      )
    def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ]
    def groupsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup.ReadOnly
    ]]
    def totalValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly]
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def groups: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groupsValue)
    def total: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly
    ] = AwsError.unwrapOptionField("total", totalValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CoverageByTime
  ) extends io.github.vigoo.zioaws.costexplorer.model.CoverageByTime.ReadOnly {
    override def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = scala
      .Option(impl.timePeriod())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.DateInterval.wrap(value)
      )
    override def groupsValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup.ReadOnly
    ]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.ReservationCoverageGroup
            .wrap(item)
        }.toList
      )
    override def totalValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Coverage.ReadOnly] =
      scala
        .Option(impl.total())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.Coverage.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CoverageByTime
  ): io.github.vigoo.zioaws.costexplorer.model.CoverageByTime.ReadOnly =
    new Wrapper(impl)
}
