package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CostCategorySplitChargeRule(
    source: GenericString,
    targets: Iterable[GenericString],
    method: io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeMethod,
    parameters: Option[Iterable[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRuleParameter
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule = {
    import CostCategorySplitChargeRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule
      .builder()
      .source(source: java.lang.String)
      .targets(targets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .method(method.unwrap)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule
      .wrap(buildAwsValue())
}
object CostCategorySplitChargeRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule =
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule(
        sourceValue,
        targetsValue,
        methodValue,
        parametersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def sourceValue: GenericString
    def targetsValue: List[GenericString]
    def methodValue
        : io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeMethod
    def parametersValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRuleParameter.ReadOnly
    ]]
    def source: ZIO[Any, Nothing, GenericString] = ZIO.succeed(sourceValue)
    def targets: ZIO[Any, Nothing, List[GenericString]] =
      ZIO.succeed(targetsValue)
    def method: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeMethod
    ] = ZIO.succeed(methodValue)
    def parameters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRuleParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parametersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule
  ) extends io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly {
    override def sourceValue: GenericString = impl.source(): GenericString
    override def targetsValue: List[GenericString] = impl
      .targets()
      .asScala
      .map { item =>
        item: GenericString
      }
      .toList
    override def methodValue
        : io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeMethod =
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeMethod
        .wrap(impl.method())
    override def parametersValue: Option[List[
      io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRuleParameter.ReadOnly
    ]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRuleParameter
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategorySplitChargeRule.ReadOnly =
    new Wrapper(impl)
}
