package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait CostCategoryRuleVersion {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion
}
object CostCategoryRuleVersion {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion =
    value match {
      case software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion.COST_CATEGORY_EXPRESSION_V1 =>
        val r = `CostCategoryExpression.v1`
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion =
      software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object `CostCategoryExpression.v1`
      extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryRuleVersion {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion =
      software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion.COST_CATEGORY_EXPRESSION_V1
  }
}
