package io.github.vigoo.zioaws.costexplorer.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  NonNegativeInteger,
  YearMonthDay,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AnomalyMonitor(
    monitorArn: Option[GenericString] = None,
    monitorName: GenericString,
    creationDate: Option[YearMonthDay] = None,
    lastUpdatedDate: Option[YearMonthDay] = None,
    lastEvaluatedDate: Option[YearMonthDay] = None,
    monitorType: io.github.vigoo.zioaws.costexplorer.model.MonitorType,
    monitorDimension: Option[
      io.github.vigoo.zioaws.costexplorer.model.MonitorDimension
    ] = None,
    monitorSpecification: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression
    ] = None,
    dimensionalValueCount: Option[NonNegativeInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor = {
    import AnomalyMonitor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor
      .builder()
      .optionallyWith(monitorArn.map(value => value: java.lang.String))(
        _.monitorArn
      )
      .monitorName(monitorName: java.lang.String)
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(lastUpdatedDate.map(value => value: java.lang.String))(
        _.lastUpdatedDate
      )
      .optionallyWith(lastEvaluatedDate.map(value => value: java.lang.String))(
        _.lastEvaluatedDate
      )
      .monitorType(monitorType.unwrap)
      .optionallyWith(monitorDimension.map(value => value.unwrap))(
        _.monitorDimension
      )
      .optionallyWith(monitorSpecification.map(value => value.buildAwsValue()))(
        _.monitorSpecification
      )
      .optionallyWith(dimensionalValueCount.map(value => value: Integer))(
        _.dimensionalValueCount
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor
      .wrap(buildAwsValue())
}
object AnomalyMonitor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor =
      io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor(
        monitorArnValue.map(value => value),
        monitorNameValue,
        creationDateValue.map(value => value),
        lastUpdatedDateValue.map(value => value),
        lastEvaluatedDateValue.map(value => value),
        monitorTypeValue,
        monitorDimensionValue.map(value => value),
        monitorSpecificationValue.map(value => value.editable),
        dimensionalValueCountValue.map(value => value)
      )
    def monitorArnValue: Option[GenericString]
    def monitorNameValue: GenericString
    def creationDateValue: Option[YearMonthDay]
    def lastUpdatedDateValue: Option[YearMonthDay]
    def lastEvaluatedDateValue: Option[YearMonthDay]
    def monitorTypeValue: io.github.vigoo.zioaws.costexplorer.model.MonitorType
    def monitorDimensionValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.MonitorDimension]
    def monitorSpecificationValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly]
    def dimensionalValueCountValue: Option[NonNegativeInteger]
    def monitorArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("monitorArn", monitorArnValue)
    def monitorName: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(monitorNameValue)
    def creationDate: ZIO[Any, AwsError, YearMonthDay] =
      AwsError.unwrapOptionField("creationDate", creationDateValue)
    def lastUpdatedDate: ZIO[Any, AwsError, YearMonthDay] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDateValue)
    def lastEvaluatedDate: ZIO[Any, AwsError, YearMonthDay] =
      AwsError.unwrapOptionField("lastEvaluatedDate", lastEvaluatedDateValue)
    def monitorType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.MonitorType
    ] = ZIO.succeed(monitorTypeValue)
    def monitorDimension: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.MonitorDimension
    ] = AwsError.unwrapOptionField("monitorDimension", monitorDimensionValue)
    def monitorSpecification: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitorSpecification",
      monitorSpecificationValue
    )
    def dimensionalValueCount: ZIO[Any, AwsError, NonNegativeInteger] = AwsError
      .unwrapOptionField("dimensionalValueCount", dimensionalValueCountValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor
  ) extends io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor.ReadOnly {
    override def monitorArnValue: Option[GenericString] =
      scala.Option(impl.monitorArn()).map(value => value: GenericString)
    override def monitorNameValue: GenericString =
      impl.monitorName(): GenericString
    override def creationDateValue: Option[YearMonthDay] =
      scala.Option(impl.creationDate()).map(value => value: YearMonthDay)
    override def lastUpdatedDateValue: Option[YearMonthDay] =
      scala.Option(impl.lastUpdatedDate()).map(value => value: YearMonthDay)
    override def lastEvaluatedDateValue: Option[YearMonthDay] =
      scala.Option(impl.lastEvaluatedDate()).map(value => value: YearMonthDay)
    override def monitorTypeValue
        : io.github.vigoo.zioaws.costexplorer.model.MonitorType =
      io.github.vigoo.zioaws.costexplorer.model.MonitorType
        .wrap(impl.monitorType())
    override def monitorDimensionValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.MonitorDimension] =
      scala
        .Option(impl.monitorDimension())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.MonitorDimension.wrap(value)
        )
    override def monitorSpecificationValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.Expression.ReadOnly
    ] = scala
      .Option(impl.monitorSpecification())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.Expression.wrap(value)
      )
    override def dimensionalValueCountValue: Option[NonNegativeInteger] = scala
      .Option(impl.dimensionalValueCount())
      .map(value => value: NonNegativeInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor
  ): io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor.ReadOnly =
    new Wrapper(impl)
}
