package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.YearMonthDay
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AnomalyDateInterval(
    startDate: YearMonthDay,
    endDate: Option[YearMonthDay] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval = {
    import AnomalyDateInterval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval
      .builder()
      .startDate(startDate: java.lang.String)
      .optionallyWith(endDate.map(value => value: java.lang.String))(_.endDate)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval
      .wrap(buildAwsValue())
}
object AnomalyDateInterval {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval =
      io.github.vigoo.zioaws.costexplorer.model
        .AnomalyDateInterval(startDateValue, endDateValue.map(value => value))
    def startDateValue: YearMonthDay
    def endDateValue: Option[YearMonthDay]
    def startDate: ZIO[Any, Nothing, YearMonthDay] = ZIO.succeed(startDateValue)
    def endDate: ZIO[Any, AwsError, YearMonthDay] =
      AwsError.unwrapOptionField("endDate", endDateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval
  ) extends io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval.ReadOnly {
    override def startDateValue: YearMonthDay = impl.startDate(): YearMonthDay
    override def endDateValue: Option[YearMonthDay] =
      scala.Option(impl.endDate()).map(value => value: YearMonthDay)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval
  ): io.github.vigoo.zioaws.costexplorer.model.AnomalyDateInterval.ReadOnly =
    new Wrapper(impl)
}
