package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  YearMonthDay,
  GenericString
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Anomaly(
    anomalyId: GenericString,
    anomalyStartDate: Option[YearMonthDay] = None,
    anomalyEndDate: Option[YearMonthDay] = None,
    dimensionValue: Option[GenericString] = None,
    rootCauses: Option[
      Iterable[io.github.vigoo.zioaws.costexplorer.model.RootCause]
    ] = None,
    anomalyScore: io.github.vigoo.zioaws.costexplorer.model.AnomalyScore,
    impact: io.github.vigoo.zioaws.costexplorer.model.Impact,
    monitorArn: GenericString,
    feedback: Option[
      io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.Anomaly = {
    import Anomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Anomaly
      .builder()
      .anomalyId(anomalyId: java.lang.String)
      .optionallyWith(anomalyStartDate.map(value => value: java.lang.String))(
        _.anomalyStartDate
      )
      .optionallyWith(anomalyEndDate.map(value => value: java.lang.String))(
        _.anomalyEndDate
      )
      .optionallyWith(dimensionValue.map(value => value: java.lang.String))(
        _.dimensionValue
      )
      .optionallyWith(
        rootCauses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rootCauses)
      .anomalyScore(anomalyScore.buildAwsValue())
      .impact(impact.buildAwsValue())
      .monitorArn(monitorArn: java.lang.String)
      .optionallyWith(feedback.map(value => value.unwrap))(_.feedback)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.costexplorer.model.Anomaly.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.Anomaly.wrap(buildAwsValue())
}
object Anomaly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.Anomaly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.Anomaly =
      io.github.vigoo.zioaws.costexplorer.model.Anomaly(
        anomalyIdValue,
        anomalyStartDateValue.map(value => value),
        anomalyEndDateValue.map(value => value),
        dimensionValueValue.map(value => value),
        rootCausesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        anomalyScoreValue.editable,
        impactValue.editable,
        monitorArnValue,
        feedbackValue.map(value => value)
      )
    def anomalyIdValue: GenericString
    def anomalyStartDateValue: Option[YearMonthDay]
    def anomalyEndDateValue: Option[YearMonthDay]
    def dimensionValueValue: Option[GenericString]
    def rootCausesValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.RootCause.ReadOnly]
    ]
    def anomalyScoreValue
        : io.github.vigoo.zioaws.costexplorer.model.AnomalyScore.ReadOnly
    def impactValue: io.github.vigoo.zioaws.costexplorer.model.Impact.ReadOnly
    def monitorArnValue: GenericString
    def feedbackValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType]
    def anomalyId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(anomalyIdValue)
    def anomalyStartDate: ZIO[Any, AwsError, YearMonthDay] =
      AwsError.unwrapOptionField("anomalyStartDate", anomalyStartDateValue)
    def anomalyEndDate: ZIO[Any, AwsError, YearMonthDay] =
      AwsError.unwrapOptionField("anomalyEndDate", anomalyEndDateValue)
    def dimensionValue: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("dimensionValue", dimensionValueValue)
    def rootCauses: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.costexplorer.model.RootCause.ReadOnly
    ]] = AwsError.unwrapOptionField("rootCauses", rootCausesValue)
    def anomalyScore: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.AnomalyScore.ReadOnly
    ] = ZIO.succeed(anomalyScoreValue)
    def impact: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.Impact.ReadOnly
    ] = ZIO.succeed(impactValue)
    def monitorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(monitorArnValue)
    def feedback: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
    ] = AwsError.unwrapOptionField("feedback", feedbackValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.Anomaly
  ) extends io.github.vigoo.zioaws.costexplorer.model.Anomaly.ReadOnly {
    override def anomalyIdValue: GenericString = impl.anomalyId(): GenericString
    override def anomalyStartDateValue: Option[YearMonthDay] =
      scala.Option(impl.anomalyStartDate()).map(value => value: YearMonthDay)
    override def anomalyEndDateValue: Option[YearMonthDay] =
      scala.Option(impl.anomalyEndDate()).map(value => value: YearMonthDay)
    override def dimensionValueValue: Option[GenericString] =
      scala.Option(impl.dimensionValue()).map(value => value: GenericString)
    override def rootCausesValue: Option[
      List[io.github.vigoo.zioaws.costexplorer.model.RootCause.ReadOnly]
    ] = scala
      .Option(impl.rootCauses())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.costexplorer.model.RootCause.wrap(item)
        }.toList
      )
    override def anomalyScoreValue
        : io.github.vigoo.zioaws.costexplorer.model.AnomalyScore.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.AnomalyScore
        .wrap(impl.anomalyScore())
    override def impactValue
        : io.github.vigoo.zioaws.costexplorer.model.Impact.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.Impact.wrap(impl.impact())
    override def monitorArnValue: GenericString =
      impl.monitorArn(): GenericString
    override def feedbackValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
    ] = scala
      .Option(impl.feedback())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.AnomalyFeedbackType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.Anomaly
  ): io.github.vigoo.zioaws.costexplorer.model.Anomaly.ReadOnly = new Wrapper(
    impl
  )
}
