package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansUtilizationByTime(
    timePeriod: io.github.vigoo.zioaws.costexplorer.model.DateInterval,
    utilization: io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization,
    savings: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings
    ] = None,
    amortizedCommitment: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime = {
    import SavingsPlansUtilizationByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime
      .builder()
      .timePeriod(timePeriod.buildAwsValue())
      .utilization(utilization.buildAwsValue())
      .optionallyWith(savings.map(value => value.buildAwsValue()))(_.savings)
      .optionallyWith(amortizedCommitment.map(value => value.buildAwsValue()))(
        _.amortizedCommitment
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime
      .wrap(buildAwsValue())
}
object SavingsPlansUtilizationByTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime(
        timePeriodValue.editable,
        utilizationValue.editable,
        savingsValue.map(value => value.editable),
        amortizedCommitmentValue.map(value => value.editable)
      )
    def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    def utilizationValue
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly
    def savingsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly
    ]
    def amortizedCommitmentValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly
    ]
    def timePeriod: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = ZIO.succeed(timePeriodValue)
    def utilization: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly
    ] = ZIO.succeed(utilizationValue)
    def savings: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly
    ] = AwsError.unwrapOptionField("savings", savingsValue)
    def amortizedCommitment: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amortizedCommitment",
      amortizedCommitmentValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime.ReadOnly {
    override def timePeriodValue
        : io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.DateInterval
        .wrap(impl.timePeriod())
    override def utilizationValue
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization.ReadOnly =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilization
        .wrap(impl.utilization())
    override def savingsValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings.ReadOnly
    ] = scala
      .Option(impl.savings())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansSavings
          .wrap(value)
      )
    override def amortizedCommitmentValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment.ReadOnly
    ] = scala
      .Option(impl.amortizedCommitment())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansAmortizedCommitment
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansUtilizationByTime.ReadOnly =
    new Wrapper(impl)
}
