package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.{
  AttributeValue,
  AttributeType
}
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlansCoverage(
    attributes: Option[Map[AttributeType, AttributeValue]] = None,
    coverage: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData
    ] = None,
    timePeriod: Option[io.github.vigoo.zioaws.costexplorer.model.DateInterval] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage = {
    import SavingsPlansCoverage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(coverage.map(value => value.buildAwsValue()))(_.coverage)
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage
      .wrap(buildAwsValue())
}
object SavingsPlansCoverage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage =
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage(
        attributesValue.map(value => value),
        coverageValue.map(value => value.editable),
        timePeriodValue.map(value => value.editable)
      )
    def attributesValue: Option[Map[AttributeType, AttributeValue]]
    def coverageValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData.ReadOnly
    ]
    def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ]
    def attributes: ZIO[Any, AwsError, Map[AttributeType, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributesValue)
    def coverage: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData.ReadOnly
    ] = AwsError.unwrapOptionField("coverage", coverageValue)
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage
  ) extends io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly {
    override def attributesValue: Option[Map[AttributeType, AttributeValue]] =
      scala
        .Option(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: AttributeType) -> (value: AttributeValue)
            })
            .toMap
        )
    override def coverageValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData.ReadOnly
    ] = scala
      .Option(impl.coverage())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverageData
          .wrap(value)
      )
    override def timePeriodValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.DateInterval.ReadOnly
    ] = scala
      .Option(impl.timePeriod())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.DateInterval.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage
  ): io.github.vigoo.zioaws.costexplorer.model.SavingsPlansCoverage.ReadOnly =
    new Wrapper(impl)
}
