package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
sealed trait OfferingClass {
  def unwrap: software.amazon.awssdk.services.costexplorer.model.OfferingClass
}
object OfferingClass {
  def wrap(
      value: software.amazon.awssdk.services.costexplorer.model.OfferingClass
  ): io.github.vigoo.zioaws.costexplorer.model.OfferingClass = value match {
    case software.amazon.awssdk.services.costexplorer.model.OfferingClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.OfferingClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.costexplorer.model.OfferingClass.CONVERTIBLE =>
      val r = CONVERTIBLE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.costexplorer.model.OfferingClass {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.OfferingClass =
      software.amazon.awssdk.services.costexplorer.model.OfferingClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD
      extends io.github.vigoo.zioaws.costexplorer.model.OfferingClass {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.OfferingClass =
      software.amazon.awssdk.services.costexplorer.model.OfferingClass.STANDARD
  }
  case object CONVERTIBLE
      extends io.github.vigoo.zioaws.costexplorer.model.OfferingClass {
    override def unwrap
        : software.amazon.awssdk.services.costexplorer.model.OfferingClass =
      software.amazon.awssdk.services.costexplorer.model.OfferingClass.CONVERTIBLE
  }
}
