package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CostCategoryProcessingStatus(
    component: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatusComponent
    ] = None,
    status: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus = {
    import CostCategoryProcessingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus
      .builder()
      .optionallyWith(component.map(value => value.unwrap))(_.component)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus
      .wrap(buildAwsValue())
}
object CostCategoryProcessingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus =
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus(
        componentValue.map(value => value),
        statusValue.map(value => value)
      )
    def componentValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatusComponent
    ]
    def statusValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatus]
    def component: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatusComponent
    ] = AwsError.unwrapOptionField("component", componentValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus
  ) extends io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly {
    override def componentValue: Option[
      io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatusComponent
    ] = scala
      .Option(impl.component())
      .map(value =>
        io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatusComponent
          .wrap(value)
      )
    override def statusValue
        : Option[io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.costexplorer.model.CostCategoryStatus
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus
  ): io.github.vigoo.zioaws.costexplorer.model.CostCategoryProcessingStatus.ReadOnly =
    new Wrapper(impl)
}
