package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericDouble
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AnomalyScore(
    maxScore: GenericDouble,
    currentScore: GenericDouble
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.AnomalyScore = {
    import AnomalyScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.AnomalyScore
      .builder()
      .maxScore(maxScore: java.lang.Double)
      .currentScore(currentScore: java.lang.Double)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.AnomalyScore.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.AnomalyScore.wrap(buildAwsValue())
}
object AnomalyScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.AnomalyScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.costexplorer.model.AnomalyScore =
      io.github.vigoo.zioaws.costexplorer.model
        .AnomalyScore(maxScoreValue, currentScoreValue)
    def maxScoreValue: GenericDouble
    def currentScoreValue: GenericDouble
    def maxScore: ZIO[Any, Nothing, GenericDouble] = ZIO.succeed(maxScoreValue)
    def currentScore: ZIO[Any, Nothing, GenericDouble] =
      ZIO.succeed(currentScoreValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.AnomalyScore
  ) extends io.github.vigoo.zioaws.costexplorer.model.AnomalyScore.ReadOnly {
    override def maxScoreValue: GenericDouble = impl.maxScore(): GenericDouble
    override def currentScoreValue: GenericDouble =
      impl.currentScore(): GenericDouble
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.AnomalyScore
  ): io.github.vigoo.zioaws.costexplorer.model.AnomalyScore.ReadOnly =
    new Wrapper(impl)
}
