package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.GenericString
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAnomalySubscriptionResponse(
    subscriptionArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse = {
    import UpdateAnomalySubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse
      .builder()
      .subscriptionArn(subscriptionArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse
      .wrap(buildAwsValue())
}
object UpdateAnomalySubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse =
      io.github.vigoo.zioaws.costexplorer.model
        .UpdateAnomalySubscriptionResponse(subscriptionArnValue)
    def subscriptionArnValue: GenericString
    def subscriptionArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(subscriptionArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.ReadOnly {
    override def subscriptionArnValue: GenericString =
      impl.subscriptionArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse
  ): io.github.vigoo.zioaws.costexplorer.model.UpdateAnomalySubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
